/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.SASCollectorIntentService;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ActivityLifecycleListener
implements Application.ActivityLifecycleCallbacks {
    private final String TAG = ActivityLifecycleListener.class.getSimpleName();
    private boolean appIsFocused = true;
    private boolean ignoreActivityReload = false;
    private AtomicInteger foregroundCounter = new AtomicInteger();
    private Activity currentActivity = null;

    public ActivityLifecycleListener(Context context) {
    }

    public void ignoreActivityReload() {
        if (this.appIsFocused) {
            SLog.d(this.TAG, "Ignoring next activity load.", new Object[0]);
            this.ignoreActivityReload = true;
        }
    }

    public Activity getCurrentActivity() {
        return this.currentActivity;
    }

    public void setCurrentActivity(Activity activity, boolean notifyListener) {
        this.currentActivity = activity;
        if (notifyListener) {
            this.foregroundCounter.set(0);
            this.onActivityStarted(activity);
        }
    }

    public void onActivityStopped(Activity activity) {
        SLog.d(this.TAG, "Activity stopped: " + activity.getLocalClassName(), new Object[0]);
        if (!this.ignoreActivityReload) {
            if (this.foregroundCounter.get() == 0 || this.foregroundCounter.decrementAndGet() == 0) {
                this.currentActivity = null;
                this.appIsFocused = false;
                InternalSingleton.get().addAppEventInternal("defocus", null);
            }
            SLog.d(this.TAG, "Foreground counter : " + this.foregroundCounter.get(), new Object[0]);
        } else {
            SLog.d(this.TAG, "Ignoring due to activity reload.", new Object[0]);
        }
    }

    public void onActivityStarted(Activity activity) {
        this.currentActivity = activity;
        SLog.d(this.TAG, "Activity started: " + activity.getLocalClassName(), new Object[0]);
        if (!this.ignoreActivityReload) {
            if (this.foregroundCounter.incrementAndGet() == 1) {
                InternalSingleton.get().notifyFocus(activity);
                this.appIsFocused = true;
                InternalSingleton.get().addAppEventInternal("focus", null);
            }
            SLog.d(this.TAG, "Foreground counter : " + this.foregroundCounter.get(), new Object[0]);
        } else {
            SLog.d(this.TAG, "Ignoring due to activity reload.", new Object[0]);
            this.ignoreActivityReload = false;
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle arg1) {
        SLog.d(this.TAG, "Activity save instance state: %s", activity.getLocalClassName());
    }

    public void onActivityResumed(Activity activity) {
        SLog.d(this.TAG, "Activity resumed: %s", activity.getLocalClassName());
        InternalSingleton.get().getMobileMessageHelper().notifyActivityResume(activity);
    }

    public void onActivityPostResumed(@NonNull Activity activity) {
        Intent intent;
        if (InternalSingleton.get().isAppRelaunchDisabledOnPushOpen() && (intent = activity.getIntent()) != null && intent.hasExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ID)) {
            SLog.d(this.TAG, "Notification click through Activity resumed for notification: " + intent.getIntExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ID, 0), new Object[0]);
            String link = intent.getStringExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ACTION_LINK);
            String actionEvent = intent.getStringExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ACTION_EVENT_ID);
            String creativeId = intent.getStringExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_CREATIVE_ID);
            String taskId = intent.getStringExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_TASK_ID);
            String spotId = intent.getStringExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_SPOT_ID);
            this.handleNotificationOpened(actionEvent, creativeId, taskId, spotId, link);
            activity.getIntent().removeExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ID);
            activity.getIntent().removeExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ACTION_LINK);
            activity.getIntent().removeExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ACTION_EVENT_ID);
            activity.getIntent().removeExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_CREATIVE_ID);
            activity.getIntent().removeExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_TASK_ID);
            activity.getIntent().removeExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_SPOT_ID);
            activity.getIntent().removeExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ACTION_EVENT_ID);
            activity.getIntent().removeExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ACTION_LINK);
        }
    }

    public void onActivityPaused(Activity activity) {
        SLog.d(this.TAG, "Activity paused: %s", activity.getLocalClassName());
        InternalSingleton.get().getMobileMessageHelper().notifyActivityPaused(activity);
    }

    public void onActivityDestroyed(Activity activity) {
        SLog.d(this.TAG, "Activity destroyed: %s", activity.getLocalClassName());
    }

    public void onActivityCreated(Activity activity, Bundle arg1) {
        SLog.d(this.TAG, "Activity created: %s", activity.getLocalClassName());
        Intent intent = activity.getIntent();
        if (intent != null && intent.hasExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ID)) {
            SLog.d(this.TAG, "Notification click through Activity started for notification: " + intent.getIntExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ID, 0), new Object[0]);
            String link = intent.getStringExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ACTION_LINK);
            String actionEvent = intent.getStringExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ACTION_EVENT_ID);
            String creativeId = intent.getStringExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_CREATIVE_ID);
            String taskId = intent.getStringExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_TASK_ID);
            String spotId = intent.getStringExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_SPOT_ID);
            this.handleNotificationOpened(actionEvent, creativeId, taskId, spotId, link);
        }
    }

    private void handleNotificationOpened(String actionEvent, String creativeId, String taskId, String spotId, String link) {
        if (actionEvent != null) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            if (creativeId != null) {
                attrs.put("creative_id", creativeId);
            }
            if (taskId != null) {
                attrs.put("task_id", taskId);
            }
            if (spotId != null) {
                attrs.put("spot_id", spotId);
            }
            if (link != null) {
                attrs.put("uri", link);
            }
            InternalSingleton.get().addAppEventInternal(actionEvent, attrs);
        } else {
            SLog.w(this.TAG, "No action event specified.", new Object[0]);
        }
    }
}

