/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ia.android.sdk;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.sas.ia.android.sdk.ContentLoadingTask;
import com.sas.ia.android.sdk.DisplayHelper;
import com.sas.ia.android.sdk.Interstitial;
import com.sas.ia.android.sdk.InterstitialWebBrowser;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.List;

public class MRAIDWebView
extends RelativeLayout {
    private static final Rect zeroRect = new Rect(0, 0, 0, 0);
    private static final int CLOSE_AREA_SIZE_DIPS = 50;
    protected WeakReference<Delegate> delegate;
    protected BenignDelegate benignDelegate = new BenignDelegate();
    protected WebView webView;
    protected String innerHTML;
    protected Handler uiHandler = new Handler();
    protected WeakReference<Activity> parentActivity;
    protected DisplayHelper displayHelper;
    public boolean isInterstitial = false;
    private MRAIDState state;
    protected boolean visible = true;
    public static boolean mraidTracing = true;
    protected int numTraces = 0;
    protected boolean mraidLoaded = false;
    private Rect screenRect = zeroRect;
    private Size screenSize;
    private Rect appRect = zeroRect;
    private Rect adRect = zeroRect;
    private boolean expandFullScreen = true;
    private Size expandSize;
    private boolean useCustomClose = false;
    private Rect resizeAdRect;
    private RelativeLayout.LayoutParams resizeLayout;
    private RelativeLayout.LayoutParams resizeCloseLayout;
    private int orientation = -1;
    private boolean actionInBrowser = false;
    public static boolean supportSMSText = true;
    public static boolean supportTelephone = true;
    private final boolean hwSupportsTelephone;
    public static boolean supportCalendar = false;
    public static boolean supportPicture = false;
    private static String userAgent;

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public MRAIDWebView(Context context, Delegate delegate) {
        super(context);
        this.state = new MRAIDNotLoaded();
        if (context instanceof Activity) {
            this.parentActivity = new WeakReference<Context>(context);
            this.delegate = new WeakReference<Delegate>(delegate);
            this.displayHelper = new DisplayHelper((Activity)this.parentActivity.get());
            if (Build.VERSION.SDK_INT >= 19) {
                this.enableWebViewDebug();
            }
            this.webView = new WatchableWebView((Activity)this.parentActivity.get());
            this.webView.addJavascriptInterface((Object)new MRAIDJSBridge(), "SASIA_MRAID");
            this.webView.setInitialScale(0);
            this.webView.setHorizontalScrollBarEnabled(false);
            this.webView.setVerticalScrollBarEnabled(false);
            this.webView.getSettings().setJavaScriptEnabled(true);
            this.webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
            this.webView.setBackgroundColor(0);
            this.webView.setWebChromeClient(new WebChromeClient());
            ((Activity)this.parentActivity.get()).getWindow().setFlags(0x1000000, 0x1000000);
            if (userAgent == null) {
                userAgent = this.webView.getSettings().getUserAgentString();
            }
            this.hwSupportsTelephone = ((Activity)this.parentActivity.get()).getPackageManager().hasSystemFeature("android.hardware.telephony");
            this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            boolean setInitialParams = this.webView.getParent() == null || !(this.webView.getParent() instanceof ScrollView);
            this.returnWebViewToContainer(setInitialParams);
            this.clearResizeProperties();
            this.position();
        } else {
            this.hwSupportsTelephone = false;
            Log.e((String)MRAIDWebView.class.getSimpleName(), (String)"Parent context is not an Activity.  Unable to configure Ad content.");
        }
    }

    @TargetApi(value=19)
    private void enableWebViewDebug() {
        WebView.setWebContentsDebuggingEnabled((boolean)true);
    }

    protected Delegate getDelegate() {
        Delegate strongDelegate = (Delegate)this.delegate.get();
        if (strongDelegate == null) {
            strongDelegate = this.benignDelegate;
        }
        return strongDelegate;
    }

    protected boolean isWebViewInContainer() {
        return this.webView.getParent() == this;
    }

    protected final void removeWebViewFromParent() {
        ViewGroup parent = (ViewGroup)this.webView.getParent();
        if (parent != null) {
            parent.removeView((View)this.webView);
        }
    }

    protected final void returnWebViewToContainer(boolean resetLayoutParams) {
        this.removeWebViewFromParent();
        if (resetLayoutParams) {
            this.webView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        }
        this.addView((View)this.webView);
    }

    public void setScale(int scale) {
        this.webView.setInitialScale(scale);
    }

    private void receiveJSString(String jsString) {
        if (this.state != null) {
            this.state.receiveJSString(jsString);
        }
    }

    public String executeJavaScript(String js, String jsStringExpression) {
        if (this.state != null) {
            return this.state.executeJavaScript(js, jsStringExpression);
        }
        return null;
    }

    public String htmlContent() {
        if (this.state != null) {
            return this.state.htmlContent();
        }
        return null;
    }

    private void openLinkExternally(String sourceFunction, Uri uri) {
        try {
            Intent actionIntent = new Intent("android.intent.action.VIEW", uri);
            this.getActivity().startActivity(actionIntent);
        }
        catch (Exception e) {
            this.mraidError(sourceFunction, "Exception attempting to open link. Exception=" + e.toString() + " URL=" + uri.toString());
        }
    }

    private void setState(MRAIDState state) {
        if (state != null) {
            MRAIDState formerState = this.state;
            this.state = state;
            if (state != null) {
                state.enterFromState(formerState);
                this.position();
                if (!state.mraidStateValue().equals(formerState.mraidStateValue())) {
                    this.mraidSetState();
                }
            }
        }
    }

    protected Activity getActivity() {
        if (this.state != null) {
            return this.state.getHostActivity();
        }
        return null;
    }

    public void load(String url) {
        this.close();
        this.setState(new MRAIDLoading(url, new MRAIDDefault()));
    }

    public void showInterstitially(Activity hostActivity, Object strongReference) {
        if (this.state != null) {
            this.state.showInterstitially(hostActivity, strongReference);
        }
    }

    protected void loadChildExpansion(String url, Activity hostActivity) {
        this.setState(new MRAIDLoading(url, new MRAIDTwoPartExpandedChild(hostActivity)));
    }

    public void close() {
        if (this.state != null) {
            this.state.close();
        }
    }

    private void orient() {
        Rect newScreenRect = this.displayHelper.screenRect();
        Rect newAppRect = this.displayHelper.appRect();
        if (!newScreenRect.equals((Object)this.screenRect) || !newAppRect.equals((Object)this.appRect)) {
            this.screenRect = newScreenRect;
            this.screenSize = new Size(this.screenRect.width(), this.screenRect.height());
            this.appRect = newAppRect;
            this.mraidOrient();
        }
        if (this.expandFullScreen) {
            this.setExpandProperties(this.screenSize);
        }
    }

    private void position() {
        this.orient();
        Rect currentAdRect = this.displayHelper.viewRect((View)this.webView);
        if (!currentAdRect.equals((Object)this.adRect)) {
            this.adRect = currentAdRect;
            this.mraidSetPosition();
            if (this.state != null) {
                this.state.onPositionChanged();
            }
        }
    }

    private void setOrientationProperties(boolean allowChange, String forcedOrientation) {
        if (forcedOrientation.equals("portrait")) {
            this.orientation = 7;
        } else if (forcedOrientation.equals("landscape")) {
            this.orientation = 6;
        } else {
            int n = this.orientation = allowChange ? -1 : 14;
        }
        if (this.state != null) {
            this.state.onOrientationPropertiesChanged();
        }
        this.orient();
    }

    public void onVisibilityChange(boolean newVisible) {
        this.position();
        if (this.visible != newVisible) {
            this.visible = newVisible;
            this.mraidSetVisibility();
        }
    }

    private void setExpandProperties(Size expandSize) {
        this.expandSize = expandSize;
        this.expandFullScreen = expandSize.equals(this.screenSize);
    }

    protected void setUseCustomClose(boolean useCustomClose) {
        this.useCustomClose = useCustomClose;
        if (this.state != null) {
            this.state.setUseCustomClose(useCustomClose);
        }
    }

    protected void expand(String url) {
        if (this.state != null) {
            this.state.expand(url);
        }
    }

    private void clearResizeProperties() {
        this.resizeAdRect = zeroRect;
    }

    private void setResizeProperties(Rect resize, String customClosePosition, boolean allowOffscreen) {
        int newCloseTop;
        int newCloseLeft;
        this.clearResizeProperties();
        this.position();
        int newLeft = this.adRect.left + resize.left;
        int newTop = this.adRect.top + resize.top;
        int newRight = newLeft + resize.width();
        int newBottom = newTop + resize.height();
        Rect newAdRect = new Rect(newLeft, newTop, newRight, newBottom);
        if (!allowOffscreen) {
            if (resize.width() > this.appRect.width() || resize.height() > this.appRect.height()) {
                this.mraidError("setResizeProperties", "resizeProperties would make ad larger than the app area.");
                return;
            }
            if (!this.appRect.contains(newAdRect)) {
                newLeft = Math.max(newAdRect.left, this.appRect.left);
                newTop = Math.max(newAdRect.top, this.appRect.top);
                int margin = this.appRect.right - newAdRect.right;
                if (margin < 0) {
                    newLeft += margin;
                }
                if ((margin = this.appRect.bottom - newAdRect.bottom) < 0) {
                    newTop += margin;
                }
                newRight = newLeft + resize.width();
                newBottom = newTop + resize.height();
                newAdRect = new Rect(newLeft, newTop, newRight, newBottom);
            }
        }
        int closeSize = this.displayHelper.dipsToPixels(50);
        RelativeLayout.LayoutParams newCloseLayout = new RelativeLayout.LayoutParams(closeSize, closeSize);
        int x_left = newLeft;
        int x_right = newRight - closeSize;
        int x_center = newLeft + (newAdRect.width() - closeSize) / 2;
        int y_top = newTop;
        int y_bottom = newBottom - closeSize;
        int y_center = newTop + (newAdRect.height() - closeSize) / 2;
        if (customClosePosition.equals("center")) {
            newCloseLeft = x_center;
            newCloseTop = y_center;
            newCloseLayout.addRule(13);
        } else {
            if (customClosePosition.endsWith("left")) {
                newCloseLeft = x_left;
                newCloseLayout.addRule(9);
            } else if (customClosePosition.endsWith("center")) {
                newCloseLeft = x_center;
                newCloseLayout.addRule(14);
            } else {
                newCloseLeft = x_right;
                newCloseLayout.addRule(11);
            }
            if (customClosePosition.startsWith("bottom")) {
                newCloseTop = y_bottom;
                newCloseLayout.addRule(12);
            } else {
                newCloseTop = y_top;
                newCloseLayout.addRule(10);
            }
        }
        Rect newCloseRect = new Rect(newCloseLeft, newCloseTop, newCloseLeft + closeSize, newCloseTop + closeSize);
        if (newAdRect.width() < closeSize || newAdRect.height() < closeSize) {
            this.mraidError("setResizeProperties", "resizeProperties would make ad smaller than close area.");
            return;
        }
        if (!this.appRect.contains(newCloseRect)) {
            this.mraidError("setResizeProperties", "resizeProperties would position close area off screen.");
            return;
        }
        this.resizeAdRect = newAdRect;
        Rect resizeRectPixels = this.displayHelper.dipsToPixels(this.resizeAdRect);
        this.resizeLayout = new RelativeLayout.LayoutParams(resizeRectPixels.width(), resizeRectPixels.height());
        this.resizeLayout.leftMargin = resizeRectPixels.left;
        this.resizeLayout.topMargin = resizeRectPixels.top;
        this.resizeCloseLayout = newCloseLayout;
    }

    protected void resize() {
        if (this.state != null) {
            this.state.resize();
        }
    }

    public boolean isActionInBrowser() {
        return this.actionInBrowser;
    }

    public void setActionInBrowser(boolean actionInBrowser) {
        this.actionInBrowser = actionInBrowser;
    }

    public void open(String url) {
        if (this.state != null) {
            this.state.openLink(url);
        }
    }

    public boolean isActionInProgress() {
        return this.getActionActivity() != null;
    }

    public Activity getActionActivity() {
        if (this.state != null) {
            return this.state.getLinkHostActivity();
        }
        return null;
    }

    public void cancelAction() {
        if (this.state != null) {
            this.state.closeLink();
        }
    }

    private boolean supportsSMSText() {
        return supportSMSText && this.hwSupportsTelephone;
    }

    private boolean supportsTelephone() {
        return supportTelephone && this.hwSupportsTelephone;
    }

    private boolean supportsPicture() {
        return false;
    }

    private void storePicture(String url) {
        if (!this.supportsPicture()) {
            this.mraidError("storePicture", "Picture storage feature is disabled.");
        }
    }

    private boolean supportsCalendar() {
        return false;
    }

    private void createCalendarEvent(String jsonParms) {
        if (!this.supportsCalendar()) {
            this.mraidError("createCalendarEvent", "Calendar event creation feature is disabled.");
        }
    }

    private void playVideo(String url) {
        Uri uri = Uri.parse((String)url);
        this.openLinkExternally("playVideo", uri);
    }

    private WebResourceResponse mraidJavaScript() {
        WebResourceResponse mraidJSResponse = null;
        InputStream mraidStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sas/ia/android/sdk/res/js/mraid.js");
        if (mraidStream == null) {
            try {
                Log.w((String)MRAIDWebView.class.getSimpleName(), (String)"mraid.js not found in classpath, attempting to load from assets.");
                mraidStream = this.getActivity().getAssets().open("mraid.js");
            }
            catch (IOException e) {
                Log.e((String)MRAIDWebView.class.getSimpleName(), (String)("Unable to load mraid.js asset: " + e.getLocalizedMessage()));
            }
        }
        if (mraidStream != null) {
            mraidJSResponse = new WebResourceResponse("application/javascript", "UTF-8", mraidStream);
        }
        return mraidJSResponse;
    }

    protected void mraidExecute(String functionCall, boolean trace) {
        if (!this.mraidLoaded) {
            return;
        }
        String fc = "window.mraidBridge." + functionCall + ";";
        if (trace) {
            this.mraidSdkTrace("Called " + fc);
        }
        this.webView.loadUrl("javascript:" + fc);
    }

    protected void mraidExecute(String functionCall) {
        this.mraidExecute(functionCall, true);
    }

    protected void mraidSdkDone() {
        this.mraidExecute("sdkExecutionDone()", false);
    }

    protected void mraidOrient() {
        this.mraidExecute("setMaxSize(" + this.appRect.width() + "," + this.appRect.height() + "," + this.screenRect.width() + "," + this.screenRect.height() + ")");
    }

    protected void mraidSdkReady() {
        if (!this.mraidLoaded || this.state == null || this.state.mraidStateValue().equals("loading")) {
            return;
        }
        this.appRect = this.adRect = zeroRect;
        this.position();
        this.mraidExecute("sdkReady(" + this.useCustomClose + "," + this.isInterstitial + ",'" + this.state == null ? "null-state" : this.state.mraidStateValue() + "'," + this.visible + "," + this.supportsSMSText() + "," + this.supportsTelephone() + "," + this.supportsPicture() + "," + this.supportsCalendar() + ")");
    }

    public void mraidSetTracing() {
        this.mraidExecute("setTracing(" + mraidTracing + ")");
    }

    public void mraidError(String mraidFunction, String message) {
        this.mraidExecute("error('" + mraidFunction + "','" + message + "')");
    }

    protected void mraidSetVisibility() {
        this.mraidExecute("setIsViewable(" + this.visible + ")");
    }

    protected void mraidSetPosition() {
        this.mraidExecute("setPosition(" + this.adRect.left + "," + this.adRect.top + "," + this.adRect.width() + "," + this.adRect.height() + ")");
    }

    protected void mraidSetDefaultPosition() {
        this.mraidExecute("setDefaultPosition()");
    }

    protected void mraidSetState() {
        if (this.state != null) {
            this.mraidExecute("setState('" + this.state.mraidStateValue() + "')");
        }
    }

    protected void mraidTrace(String type, String message) {
        if (mraidTracing) {
            Log.d((String)("MRAID-TRACE-" + type), (String)(String.valueOf(++this.numTraces) + ": " + message));
        }
    }

    protected void mraidJsTrace(String message) {
        this.mraidTrace("JS", message);
    }

    protected void mraidAdTrace(String message) {
        this.mraidTrace("AD", message);
    }

    protected void mraidSdkTrace(String message) {
        this.mraidTrace("SDK", message);
    }

    protected final void mraidSdkError(String message) {
        this.mraidSdkTrace("Error: " + message);
    }

    private int parseInt(String iString, int iDefault) {
        try {
            return Integer.parseInt(iString);
        }
        catch (Exception e) {
            return iDefault;
        }
    }

    protected void processMraidCommand(String command, List<String> parameters) {
        int nParms = parameters.size();
        if (command.equals("setExpandProperties")) {
            Size newExpandSize = new Size(0, 0);
            newExpandSize.width = nParms < 2 ? this.expandSize.width : this.parseInt(parameters.get(0), this.expandSize.width);
            newExpandSize.height = nParms < 3 ? this.expandSize.height : this.parseInt(parameters.get(1), this.expandSize.height);
            boolean newUseCustomClose = nParms < 4 ? this.useCustomClose : "true".equals(parameters.get(2));
            this.setExpandProperties(newExpandSize);
            this.setUseCustomClose(newUseCustomClose);
        } else if (command.equals("expand")) {
            String destUrl = nParms < 1 || parameters.get(0).length() <= 1 ? "" : Uri.decode((String)parameters.get(0));
            this.expand(destUrl);
        } else if (command.equals("setResizeProperties")) {
            if (nParms == 6) {
                Rect newRect = new Rect();
                newRect.left = this.parseInt(parameters.get(0), this.resizeAdRect.left);
                newRect.top = this.parseInt(parameters.get(1), this.resizeAdRect.top);
                newRect.right = newRect.left + this.parseInt(parameters.get(2), this.resizeAdRect.width());
                newRect.bottom = newRect.top + this.parseInt(parameters.get(3), this.resizeAdRect.height());
                String customClosePosition = parameters.get(4);
                boolean allowOffscreen = parameters.get(5).equals("true");
                this.setResizeProperties(newRect, customClosePosition, allowOffscreen);
            }
        } else if (command.equals("resize")) {
            this.resize();
        } else if (command.equals("open")) {
            String destUrl;
            String string2 = destUrl = nParms == 0 ? "" : Uri.decode((String)parameters.get(0));
            if (!destUrl.isEmpty()) {
                this.open(destUrl);
            }
        } else if (command.equals("close")) {
            this.close();
        } else if (command.equals("setOrientationProperties")) {
            if (nParms == 2) {
                boolean allowChange = parameters.get(0).equals("true");
                String forceOrientation = parameters.get(1);
                this.setOrientationProperties(allowChange, forceOrientation);
            }
        } else if (command.equals("useCustomClose")) {
            boolean newUseCustomClose = nParms >= 1 && "true".equals(parameters.get(0));
            this.setUseCustomClose(newUseCustomClose);
        } else if (command.equals("playVideo")) {
            String destUrl;
            String string3 = destUrl = nParms == 0 ? "" : Uri.decode((String)parameters.get(0));
            if (!destUrl.isEmpty()) {
                this.playVideo(destUrl);
            }
        } else if (command.equals("storePicture")) {
            String destUrl;
            String string4 = destUrl = nParms == 0 ? "" : Uri.decode((String)parameters.get(0));
            if (!destUrl.isEmpty()) {
                this.storePicture(destUrl);
            }
        } else if (command.equals("createCalendarEvent")) {
            String calParms;
            String string5 = calParms = nParms == 0 ? "" : Uri.decode((String)parameters.get(0));
            if (!calParms.isEmpty()) {
                this.createCalendarEvent(calParms);
            }
        } else if (command.equals("trace")) {
            String message = nParms == 0 ? "" : Uri.decode((String)parameters.get(0));
            this.mraidJsTrace(message);
        } else if (command.equals("traceAd")) {
            String message = nParms == 0 ? "" : Uri.decode((String)parameters.get(0));
            this.mraidAdTrace(message);
        } else if (command.equals("loaded")) {
            this.mraidJsTrace("mraid.js loaded");
            this.mraidLoaded = true;
            this.mraidSetTracing();
            this.mraidSdkReady();
        } else {
            this.mraidSdkError("Received unrecognized command: " + command);
        }
        this.mraidSdkDone();
    }

    private class MRAIDJSBridge {
        private MRAIDJSBridge() {
        }

        @JavascriptInterface
        public void receiveInnerHTML(String innerHTML) {
            MRAIDWebView.this.innerHTML = innerHTML;
        }

        @JavascriptInterface
        public void receiveJSString(String jsString) {
            MRAIDWebView.this.receiveJSString(jsString);
        }
    }

    protected class WatchableWebView
    extends WebView {
        WatchableWebView(Activity parentActivity) {
            super((Context)parentActivity);
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
            MRAIDWebView.this.position();
        }
    }

    private class Size {
        public int width;
        public int height;

        Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        boolean equals(Size other) {
            return this.width == other.width && this.height == other.height;
        }
    }

    protected class MRAIDLinkOpened
    extends MRAIDNotLoaded {
        private final String url;
        private MRAIDState formerState;
        private WeakReference<InterstitialWebBrowser> _browser;

        private InterstitialWebBrowser browser() {
            return (InterstitialWebBrowser)this._browser.get();
        }

        MRAIDLinkOpened(String url) {
            this.url = url;
        }

        @Override
        protected MRAIDState closeState() {
            return this.formerState;
        }

        @Override
        protected void beginFromState(MRAIDState formerState) {
            this.formerState = new MRAIDNestedState(formerState);
            InterstitialWebBrowser strongBrowser = new InterstitialWebBrowser();
            this._browser = new WeakReference<InterstitialWebBrowser>(strongBrowser);
            MRAIDWebView.this.onVisibilityChange(false);
            InterstitialWebBrowser.Delegate browserDelegate = new InterstitialWebBrowser.Delegate(){

                @Override
                public void onClose() {
                    MRAIDLinkOpened.this.doClose();
                }
            };
            this.browser().show((Context)formerState.getHostActivity(), this.url, browserDelegate);
        }

        @Override
        protected boolean willClose() {
            return false;
        }

        @Override
        protected void doClose() {
            MRAIDWebView strongMraidView = MRAIDWebView.this;
            super.doClose();
            strongMraidView.getDelegate().onActionFinished(strongMraidView);
        }

        @Override
        public void closeLink() {
            this.browser().close();
        }

        @Override
        public Activity getHostActivity() {
            return this.formerState.getHostActivity();
        }

        @Override
        public Activity getLinkHostActivity() {
            return this.browser().getActivity();
        }

        @Override
        public String mraidStateValue() {
            return this.formerState.mraidStateValue();
        }
    }

    protected class MRAIDResized
    extends MRAIDResizable {
        private MRAIDState formerState;
        private RelativeLayout resizeView;
        private RelativeLayout topResizeView;
        private ImageView closeView;

        protected MRAIDResized() {
        }

        @Override
        protected MRAIDState closeState() {
            return this.formerState;
        }

        @Override
        protected void beginFromState(MRAIDState formerState) {
            this.formerState = new MRAIDNestedState(formerState);
            MRAIDWebView.this.removeWebViewFromParent();
            Activity activity = formerState.getHostActivity();
            this.closeView = new ImageView((Context)activity);
            this.closeView.setScaleType(ImageView.ScaleType.FIT_XY);
            this.closeView.setLayoutParams((ViewGroup.LayoutParams)MRAIDWebView.this.resizeCloseLayout);
            this.closeView.setImageDrawable(null);
            this.closeView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MRAIDResized.this.close();
                }
            });
            this.resizeView = new RelativeLayout((Context)activity);
            this.resizeView.setLayoutParams((ViewGroup.LayoutParams)MRAIDWebView.this.resizeLayout);
            this.resizeView.addView((View)MRAIDWebView.this.webView);
            this.resizeView.addView((View)this.closeView);
            this.topResizeView = new RelativeLayout((Context)activity);
            this.topResizeView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            this.topResizeView.addView((View)this.resizeView);
            MRAIDWebView.this.displayHelper.topView().addView((View)this.topResizeView);
            MRAIDWebView.this.webView.zoomOut();
        }

        @Override
        protected void doClose() {
            MRAIDWebView strongMraidView = MRAIDWebView.this;
            MRAIDWebView.this.returnWebViewToContainer(true);
            MRAIDWebView.this.displayHelper.topView().removeView((View)this.topResizeView);
            super.doClose();
            strongMraidView.getDelegate().onResizeFinished(strongMraidView);
        }

        @Override
        public void resize() {
            if (this.willResize()) {
                this.resizeView.setLayoutParams((ViewGroup.LayoutParams)MRAIDWebView.this.resizeLayout);
                this.closeView.setLayoutParams((ViewGroup.LayoutParams)MRAIDWebView.this.resizeCloseLayout);
                MRAIDWebView.this.webView.zoomOut();
                MRAIDWebView.this.mraidSetState();
            }
        }

        @Override
        public String mraidStateValue() {
            return "resized";
        }
    }

    protected class MRAIDTwoPartExpandedChild
    extends MRAIDExpandedBase {
        private final Activity hostActivity;
        private WeakReference<Interstitial> _interstitial;

        private Interstitial interstitial() {
            return (Interstitial)this._interstitial.get();
        }

        MRAIDTwoPartExpandedChild(Activity hostActivity) {
            this.hostActivity = hostActivity;
        }

        @Override
        protected void beginFromState(MRAIDState formerState) {
            Interstitial.Delegate interstitialDelegate = new Interstitial.Delegate(){

                @Override
                public void onVisibilityChange(boolean visible) {
                    MRAIDWebView.this.onVisibilityChange(visible);
                }

                @Override
                public void onConfigurationChanged(Configuration newConfig) {
                    MRAIDWebView.this.orient();
                }

                @Override
                public void close() {
                    MRAIDTwoPartExpandedChild.super.close();
                }
            };
            Interstitial strongInterstitial = new Interstitial((View)MRAIDWebView.this, (Context)formerState.getHostActivity(), interstitialDelegate, interstitialDelegate);
            this._interstitial = new WeakReference<Interstitial>(strongInterstitial);
            strongInterstitial.usesCloseIcon = !MRAIDWebView.this.useCustomClose;
            this.onOrientationPropertiesChanged();
            strongInterstitial.show();
        }

        @Override
        protected void doClose() {
            MRAIDWebView strongMraidView = MRAIDWebView.this;
            this.interstitial().doClose();
            super.doClose();
            MRAIDWebView.this.getDelegate().onClosed(MRAIDWebView.this);
        }

        @Override
        public void close() {
            this.interstitial().close();
        }

        @Override
        public void setUseCustomClose(boolean useCustomClose) {
            this.interstitial().setUsesCloseIcon(!useCustomClose);
        }

        @Override
        public void onOrientationPropertiesChanged() {
            this.interstitial().setOrientation(MRAIDWebView.this.orientation);
        }

        @Override
        public Activity getHostActivity() {
            return this.interstitial().getActivity();
        }
    }

    protected class MRAIDTwoPartExpandedParent
    extends MRAIDExpandedBase {
        private final String url;
        private MRAIDState formerState;
        private MRAIDWebView childMraidView;
        private final Delegate childDelegate;

        MRAIDTwoPartExpandedParent(String url) {
            this.childDelegate = new ExpandedChildDelegate();
            this.url = url;
        }

        @Override
        protected MRAIDState closeState() {
            return this.formerState;
        }

        @Override
        public void beginFromState(MRAIDState formerState) {
            this.formerState = new MRAIDNestedState(formerState);
            this.childMraidView = new MRAIDWebView((Context)formerState.getHostActivity(), this.childDelegate);
            this.childMraidView.setLayoutParams((ViewGroup.LayoutParams)this.expansionLayout());
            this.childMraidView.setExpandProperties(MRAIDWebView.this.expandSize);
            this.childMraidView.setUseCustomClose(MRAIDWebView.this.useCustomClose);
            this.childMraidView.actionInBrowser = MRAIDWebView.this.actionInBrowser;
            this.childMraidView.visible = false;
            this.childMraidView.loadChildExpansion(this.url, formerState.getHostActivity());
        }

        @Override
        protected void doClose() {
            this.childMraidView.close();
            super.doClose();
        }

        @Override
        public Activity getHostActivity() {
            return this.childMraidView.getActivity();
        }

        class ExpandedChildDelegate
        extends BenignDelegate {
            ExpandedChildDelegate() {
            }

            @Override
            public void onLoadFailed(MRAIDWebView mraidView, int errorCode, String description, String failingUrl) {
                MRAIDTwoPartExpandedParent.this.close();
            }

            @Override
            public boolean willBeginAction(MRAIDWebView mraidView, String url) {
                return MRAIDWebView.this.getDelegate().willBeginAction(MRAIDWebView.this, url);
            }

            @Override
            public void onActionFinished(MRAIDWebView mraidView) {
                MRAIDWebView.this.getDelegate().onActionFinished(MRAIDWebView.this);
            }

            @Override
            public void onClosed(MRAIDWebView mraidView) {
                MRAIDTwoPartExpandedParent.this.close();
                MRAIDWebView.this.getDelegate().onExpandFinished(MRAIDWebView.this);
            }
        }
    }

    protected class MRAIDExpanded
    extends MRAIDExpandedBase {
        private MRAIDState formerState;
        private WeakReference<Interstitial> _interstitial;

        protected MRAIDExpanded() {
        }

        private Interstitial interstitial() {
            return (Interstitial)this._interstitial.get();
        }

        @Override
        protected MRAIDState closeState() {
            return this.formerState;
        }

        @Override
        public void beginFromState(MRAIDState formerState) {
            this.formerState = new MRAIDNestedState(formerState);
            MRAIDWebView.this.removeWebViewFromParent();
            MRAIDWebView.this.webView.setLayoutParams((ViewGroup.LayoutParams)this.expansionLayout());
            Interstitial.Delegate interstitialDelegate = new Interstitial.Delegate(){

                @Override
                public void onVisibilityChange(boolean visible) {
                    if (!MRAIDWebView.this.isWebViewInContainer()) {
                        MRAIDWebView.this.onVisibilityChange(visible);
                    }
                }

                @Override
                public void onConfigurationChanged(Configuration newConfig) {
                    MRAIDWebView.this.orient();
                }

                @Override
                public void close() {
                    MRAIDExpanded.super.close();
                }
            };
            Interstitial strongInterstitial = new Interstitial((View)MRAIDWebView.this.webView, (Context)formerState.getHostActivity(), interstitialDelegate, interstitialDelegate);
            this._interstitial = new WeakReference<Interstitial>(strongInterstitial);
            strongInterstitial.usesCloseIcon = !MRAIDWebView.this.useCustomClose;
            this.onOrientationPropertiesChanged();
            strongInterstitial.show();
        }

        @Override
        protected void doClose() {
            MRAIDWebView strongMraidView = MRAIDWebView.this;
            MRAIDWebView.this.returnWebViewToContainer(true);
            this.interstitial().doClose();
            super.doClose();
            MRAIDWebView.this.getDelegate().onExpandFinished(MRAIDWebView.this);
        }

        @Override
        public void close() {
            this.interstitial().close();
        }

        @Override
        public void setUseCustomClose(boolean useCustomClose) {
            this.interstitial().setUsesCloseIcon(!useCustomClose);
        }

        @Override
        public void onOrientationPropertiesChanged() {
            this.interstitial().setOrientation(MRAIDWebView.this.orientation);
        }

        @Override
        public Activity getHostActivity() {
            return this.interstitial().getActivity();
        }
    }

    protected class MRAIDExpandedBase
    extends MRAIDLoaded {
        protected MRAIDExpandedBase() {
        }

        protected RelativeLayout.LayoutParams expansionLayout() {
            if (MRAIDWebView.this.expandFullScreen) {
                return new RelativeLayout.LayoutParams(-1, -1);
            }
            return new RelativeLayout.LayoutParams(MRAIDWebView.this.displayHelper.dipsToPixels(((MRAIDWebView)MRAIDWebView.this).expandSize.width), MRAIDWebView.this.displayHelper.dipsToPixels(((MRAIDWebView)MRAIDWebView.this).expandSize.height));
        }

        @Override
        public void resize() {
            MRAIDWebView.this.mraidError("resize", "Ad is currently expanded.");
        }

        @Override
        public String mraidStateValue() {
            return "expanded";
        }
    }

    protected class MRAIDDefaultInterstitial
    extends MRAIDDefault {
        private final Activity hostActivity;
        private Object strongReference;
        private WeakReference<Interstitial> _interstitial;

        private Interstitial interstitial() {
            return (Interstitial)this._interstitial.get();
        }

        MRAIDDefaultInterstitial(Activity hostActivity, Object strongReference) {
            this.hostActivity = hostActivity;
            this.strongReference = strongReference;
        }

        @Override
        public void beginFromState(MRAIDState formerState) {
            Interstitial.Delegate interstitialDelegate = new Interstitial.Delegate(){

                @Override
                public void onVisibilityChange(boolean visible) {
                    MRAIDWebView.this.onVisibilityChange(visible);
                }

                @Override
                public void onConfigurationChanged(Configuration newConfig) {
                    MRAIDWebView.this.orient();
                }

                @Override
                public void close() {
                    MRAIDDefaultInterstitial.super.close();
                }
            };
            Interstitial strongInterstitial = new Interstitial((View)MRAIDWebView.this, (Context)formerState.getHostActivity(), interstitialDelegate, interstitialDelegate);
            this._interstitial = new WeakReference<Interstitial>(strongInterstitial);
            strongInterstitial.usesCloseIcon = !MRAIDWebView.this.useCustomClose;
            this.onOrientationPropertiesChanged();
            strongInterstitial.show();
        }

        @Override
        public void showInterstitially(Activity hostActivity, Object strongReference) {
        }

        @Override
        public void expand(String url) {
        }

        @Override
        public void resize() {
        }

        @Override
        protected void doClose() {
            this.strongReference = null;
            this.interstitial().doClose();
            super.doClose();
        }

        @Override
        public void close() {
            this.interstitial().close();
        }

        @Override
        public void setUseCustomClose(boolean useCustomClose) {
            this.interstitial().setUsesCloseIcon(!useCustomClose);
        }

        @Override
        public void onOrientationPropertiesChanged() {
            this.interstitial().setOrientation(MRAIDWebView.this.orientation);
        }

        @Override
        public Activity getHostActivity() {
            return this.interstitial().getActivity();
        }
    }

    protected class MRAIDDefault
    extends MRAIDResizable {
        protected MRAIDDefault() {
        }

        @Override
        public void enterFromState(MRAIDState formerState) {
            super.enterFromState(formerState);
            this.onPositionChanged();
        }

        @Override
        public void showInterstitially(Activity hostActivity, Object strongReference) {
            MRAIDWebView.this.setState(new MRAIDDefaultInterstitial(hostActivity, strongReference));
        }

        @Override
        public void resize() {
            if (this.willResize()) {
                MRAIDWebView.this.setState(new MRAIDResized());
            }
        }

        @Override
        protected boolean willClose() {
            return MRAIDWebView.this.getDelegate().willClose(MRAIDWebView.this);
        }

        @Override
        protected void doClose() {
            MRAIDWebView strongMraidView = MRAIDWebView.this;
            super.doClose();
            MRAIDWebView.this.getDelegate().onClosed(MRAIDWebView.this);
        }

        @Override
        public void onPositionChanged() {
            MRAIDWebView.this.mraidSetDefaultPosition();
        }

        @Override
        public String mraidStateValue() {
            return "default";
        }
    }

    protected class MRAIDResizable
    extends MRAIDLoaded {
        protected MRAIDResizable() {
        }

        @Override
        public void expand(String url) {
            if (!MRAIDWebView.this.getDelegate().willExpand(MRAIDWebView.this, url)) {
                MRAIDWebView.this.mraidError("expand", "App disallows expand at this time.");
                return;
            }
            if (url == null || url.isEmpty()) {
                MRAIDWebView.this.setState(new MRAIDExpanded());
            } else {
                MRAIDWebView.this.setState(new MRAIDTwoPartExpandedParent(url));
            }
        }

        protected boolean willResize() {
            if (MRAIDWebView.this.resizeAdRect.equals((Object)zeroRect)) {
                MRAIDWebView.this.mraidError("resize", "resizeProperties have not been set.");
                return false;
            }
            if (!MRAIDWebView.this.getDelegate().willResize(MRAIDWebView.this, MRAIDWebView.this.resizeAdRect)) {
                MRAIDWebView.this.mraidError("resize", "App disallows resize at this time.");
                return false;
            }
            return true;
        }
    }

    protected class MRAIDHidden
    extends MRAIDLoaded {
        protected MRAIDHidden() {
        }

        @Override
        protected MRAIDState closeState() {
            return this;
        }

        @Override
        public void openLink(String url) {
        }

        @Override
        public String mraidStateValue() {
            return "hidden";
        }
    }

    protected class MRAIDLoaded
    extends MRAIDNotLoaded {
        private static final long jsTimeout = 3000000000L;
        private boolean waitingForJs;
        private String jsString;

        protected MRAIDLoaded() {
            this.waitingForJs = false;
        }

        @Override
        protected MRAIDState closeState() {
            return new MRAIDHidden();
        }

        @Override
        public void openLink(String url) {
            Uri uri = Uri.parse((String)url);
            String scheme = uri.getScheme();
            boolean actionCanBegin = MRAIDWebView.this.getDelegate().willBeginAction(MRAIDWebView.this, url);
            if (actionCanBegin) {
                if ("sms".equals(scheme)) {
                    if (MRAIDWebView.this.supportsSMSText()) {
                        MRAIDWebView.this.openLinkExternally("open", uri);
                    } else {
                        MRAIDWebView.this.mraidError("open", "SMS text feature is disabled.");
                    }
                } else if ("tel".equals(scheme)) {
                    if (MRAIDWebView.this.supportsTelephone()) {
                        MRAIDWebView.this.openLinkExternally("open", uri);
                    } else {
                        MRAIDWebView.this.mraidError("open", "Telephone feature is disabled.");
                    }
                } else {
                    boolean openInBrowser = MRAIDWebView.this.actionInBrowser;
                    if (!"http".equals(scheme) && !"https".equals(scheme)) {
                        openInBrowser = true;
                    }
                    if (openInBrowser) {
                        MRAIDWebView.this.openLinkExternally("open", uri);
                    } else {
                        MRAIDWebView.this.setState(new MRAIDLinkOpened(url));
                    }
                }
            }
        }

        @Override
        public String htmlContent() {
            return MRAIDWebView.this.innerHTML;
        }

        @Override
        public void receiveJSString(String jsString) {
            this.jsString = jsString;
            this.waitingForJs = false;
        }

        @Override
        public String executeJavaScript(String js, String jsStringExpression) {
            long startTime = System.nanoTime();
            js = js == null ? "" : js + "\n";
            if (jsStringExpression == null) {
                jsStringExpression = "";
            }
            js = js + "\nwindow.SASIA_MRAID.receiveJSString(" + jsStringExpression + ")";
            js = "try { " + js + " } catch(sasiaJsError) { window.SASIA_MRAID.receiveJSString(\"ERROR\") }";
            Log.d((String)"MRAIDWebView", (String)("JS to execute: " + js));
            this.jsString = null;
            this.waitingForJs = true;
            MRAIDWebView.this.webView.loadUrl("javascript:" + js);
            while (this.waitingForJs) {
                long elapsedTime = System.nanoTime() - startTime;
                if (elapsedTime > 3000000000L) {
                    Log.d((String)MRAIDWebView.class.getSimpleName(), (String)"Timeout waiting for JS execution.");
                    MRAIDWebView.this.webView.stopLoading();
                    this.waitingForJs = false;
                    break;
                }
                SystemClock.sleep((long)500L);
            }
            return this.jsString;
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            if (super.shouldOverrideUrlLoading(view, request)) {
                return true;
            }
            this.openLink(request.getUrl().toString());
            return true;
        }
    }

    protected class MRAIDLoading
    extends MRAIDNotLoaded
    implements ContentLoadingTask.ContentLoadingListener {
        private final String url;
        private MRAIDState successState;
        private ContentLoadingTask contentTask;
        private boolean errorLoading;

        MRAIDLoading(String url, MRAIDState successState) {
            this.errorLoading = false;
            this.url = url;
            this.successState = successState;
        }

        @Override
        protected void beginFromState(MRAIDState formerState) {
            MRAIDWebView.this.webView.stopLoading();
            MRAIDWebView.this.numTraces = 0;
            MRAIDWebView.this.mraidLoaded = false;
            MRAIDWebView.this.innerHTML = "";
            this.contentTask = new ContentLoadingTask(this.url, userAgent, this);
            Thread t = new Thread(this.contentTask);
            t.start();
        }

        @Override
        protected MRAIDState closeState() {
            return new MRAIDNotLoaded();
        }

        @Override
        protected void doClose() {
            if (this.contentTask != null) {
                this.contentTask.cancel();
                this.contentTask = null;
            }
            super.doClose();
        }

        @Override
        public String mraidStateValue() {
            return "loading";
        }

        protected void onLoadFailed(int errorCode, String description, String failingUrl) {
            MRAIDWebView.this.getDelegate().onLoadFailed(MRAIDWebView.this, errorCode, description, failingUrl);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (this.errorLoading) {
                return;
            }
            this.postToUI(new Runnable(){

                @Override
                public void run() {
                    try {
                        MRAIDLoading strongThis = MRAIDLoading.this;
                        MRAIDWebView.this.setState(MRAIDLoading.this.successState);
                        MRAIDLoading.this.successState = null;
                        MRAIDWebView.this.mraidSdkReady();
                        MRAIDWebView.this.getDelegate().onLoaded(MRAIDWebView.this);
                    }
                    catch (Exception e) {
                        Log.w((String)MRAIDLoading.class.getSimpleName(), (String)("Error processing page finished event: " + e.getClass().getSimpleName() + " " + e.getMessage()));
                    }
                }
            });
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            super.onReceivedError(view, request, error);
            if (this.errorLoading) {
                return;
            }
            this.errorLoading = true;
            if (Build.VERSION.SDK_INT >= 23) {
                final int errorCode = error.getErrorCode();
                final String description = error.getDescription().toString();
                final String failingUrl = request.getUrl().toString();
                this.runInUI(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MRAIDLoading.this.onLoadFailed(errorCode, description, failingUrl);
                        }
                        catch (Exception e) {
                            Log.w((String)MRAIDLoading.class.getSimpleName(), (String)("Error processing page error: " + e.getClass().getSimpleName() + " " + e.getMessage()));
                        }
                    }
                });
            } else {
                Log.w((String)MRAIDWebView.class.getSimpleName(), (String)("Unable to process error, unexpected platform version " + Build.VERSION.SDK_INT));
            }
        }

        @Override
        public void loadComplete(final String pageContent, final String errorMessage) {
            this.postToUI(new Runnable(){

                @Override
                public void run() {
                    if (pageContent == null || pageContent.isEmpty()) {
                        MRAIDLoading.this.onLoadFailed(999, "Ad html could not be loaded", MRAIDLoading.this.url);
                    } else if (errorMessage != null) {
                        MRAIDLoading.this.onLoadFailed(998, errorMessage, MRAIDLoading.this.url);
                    } else {
                        String urlString = MRAIDLoading.this.url;
                        if (urlString != null) {
                            int cut = urlString.indexOf("://");
                            if (cut == -1) {
                                int cutFinal = urlString.indexOf("/");
                                urlString = cutFinal == -1 ? "" : urlString.substring(0, cutFinal);
                            } else {
                                int cutFinal = urlString.indexOf("/", cut + 3);
                                if (cutFinal > -1) {
                                    urlString = urlString.substring(0, cutFinal);
                                }
                            }
                        }
                        MRAIDWebView.this.webView.loadDataWithBaseURL(urlString, pageContent, "text/html", "UTF-8", null);
                    }
                }
            });
        }
    }

    protected class MRAIDNestedState
    extends MRAIDNotLoaded {
        private final MRAIDState nestedState;
        private final boolean nestedVisible;

        MRAIDNestedState(MRAIDState nestedState) {
            this.nestedState = nestedState;
            this.nestedVisible = MRAIDWebView.this.visible;
        }

        @Override
        public void enterFromState(MRAIDState formerState) {
            MRAIDWebView.this.onVisibilityChange(this.nestedVisible);
            MRAIDWebView.this.setState(this.nestedState);
        }

        @Override
        public Activity getHostActivity() {
            return this.nestedState.getHostActivity();
        }

        @Override
        public String mraidStateValue() {
            return this.nestedState.mraidStateValue();
        }
    }

    protected class MRAIDNotLoaded
    extends WebViewClient
    implements MRAIDState {
        private boolean begun = false;

        protected MRAIDNotLoaded() {
        }

        protected void beginFromState(MRAIDState formerState) {
        }

        @Override
        public void enterFromState(MRAIDState formerState) {
            MRAIDWebView.this.webView.setWebViewClient((WebViewClient)this);
            if (!this.begun) {
                this.begun = true;
                this.beginFromState(formerState);
            }
        }

        @Override
        public Activity getHostActivity() {
            return (Activity)MRAIDWebView.this.webView.getContext();
        }

        @Override
        public void showInterstitially(Activity hostActivity, Object strongReference) {
        }

        protected MRAIDState closeState() {
            return this;
        }

        protected void doClose() {
            MRAIDWebView.this.setState(this.closeState());
        }

        protected boolean willClose() {
            return true;
        }

        @Override
        public void close() {
            if (this.willClose()) {
                this.doClose();
            }
        }

        @Override
        public void expand(String url) {
        }

        @Override
        public void setUseCustomClose(boolean useCustomClose) {
        }

        @Override
        public void resize() {
        }

        @Override
        public void onOrientationPropertiesChanged() {
        }

        @Override
        public void onPositionChanged() {
        }

        @Override
        public void openLink(String url) {
        }

        @Override
        public void closeLink() {
        }

        @Override
        public Activity getLinkHostActivity() {
            return null;
        }

        @Override
        public String htmlContent() {
            return null;
        }

        @Override
        public void receiveJSString(String jsString) {
        }

        @Override
        public String executeJavaScript(String js, String jsStringExpression) {
            return null;
        }

        @Override
        public String mraidStateValue() {
            return "";
        }

        protected final void runInUI(Runnable runnable) {
            MRAIDWebView.this.getActivity().runOnUiThread(runnable);
        }

        protected final void postToUI(Runnable runnable) {
            MRAIDWebView.this.uiHandler.post(runnable);
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            if (request.getUrl().toString().endsWith("mraid.js")) {
                return MRAIDWebView.this.mraidJavaScript();
            }
            return null;
        }

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            Uri uri = request.getUrl();
            String scheme = uri.getScheme();
            if (scheme.equals("mraid")) {
                final String command = uri.getHost();
                final List parameters = uri.getPathSegments();
                this.postToUI(new Runnable(){

                    @Override
                    public void run() {
                        MRAIDWebView.this.processMraidCommand(command, parameters);
                    }
                });
                return true;
            }
            return false;
        }
    }

    protected static interface MRAIDState {
        public void enterFromState(MRAIDState var1);

        public Activity getHostActivity();

        public void showInterstitially(Activity var1, Object var2);

        public void close();

        public void expand(String var1);

        public void setUseCustomClose(boolean var1);

        public void resize();

        public void onOrientationPropertiesChanged();

        public void onPositionChanged();

        public void openLink(String var1);

        public void closeLink();

        public Activity getLinkHostActivity();

        public String htmlContent();

        public void receiveJSString(String var1);

        public String executeJavaScript(String var1, String var2);

        public String mraidStateValue();
    }

    public class BenignDelegate
    implements Delegate {
        @Override
        public void onLoaded(MRAIDWebView mraidView) {
        }

        @Override
        public void onLoadFailed(MRAIDWebView mraidView, int errorCode, String description, String failingUrl) {
        }

        @Override
        public boolean willClose(MRAIDWebView mraidView) {
            return true;
        }

        @Override
        public void onClosed(MRAIDWebView mraidView) {
        }

        @Override
        public boolean willBeginAction(MRAIDWebView mraidView, String url) {
            return true;
        }

        @Override
        public void onActionFinished(MRAIDWebView mraidView) {
        }

        @Override
        public boolean willExpand(MRAIDWebView mraidView, String url) {
            return true;
        }

        @Override
        public void onExpandFinished(MRAIDWebView mraidView) {
        }

        @Override
        public boolean willResize(MRAIDWebView mraidView, Rect size) {
            return true;
        }

        @Override
        public void onResizeFinished(MRAIDWebView mraidView) {
        }

        @Override
        public void useCustomClose(MRAIDWebView mraidView, boolean useCustomClose) {
        }
    }

    public static interface Delegate {
        public void onLoaded(MRAIDWebView var1);

        public void onLoadFailed(MRAIDWebView var1, int var2, String var3, String var4);

        public boolean willClose(MRAIDWebView var1);

        public void onClosed(MRAIDWebView var1);

        public boolean willBeginAction(MRAIDWebView var1, String var2);

        public void onActionFinished(MRAIDWebView var1);

        public boolean willExpand(MRAIDWebView var1, String var2);

        public void onExpandFinished(MRAIDWebView var1);

        public boolean willResize(MRAIDWebView var1, Rect var2);

        public void onResizeFinished(MRAIDWebView var1);

        public void useCustomClose(MRAIDWebView var1, boolean var2);
    }
}

