/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ia.android.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import java.util.HashMap;
import java.util.Map;

public abstract class LaggingActivity
extends Activity {
    private static final String ACTIVITY_ID = "ACTIVITY_ID";
    private static Map<Integer, Object> activityObjects = new HashMap<Integer, Object>();
    private static int nextActivityId = 0;
    private int activityId;
    protected boolean softDestroy = false;

    private static Object get(int activityId) {
        Integer aId = activityId;
        return activityObjects.get(aId);
    }

    private static int put(Object activityObject) {
        int activityId = nextActivityId++;
        activityObjects.put(activityId, activityObject);
        return activityId;
    }

    private static void remove(int activityId) {
        Integer aId = activityId;
        Object activityObject = activityObjects.get(aId);
        if (activityObject != null) {
            activityObjects.remove(aId);
        }
    }

    protected static void start(Context parentContext, Class activityClass, Object activityObject) {
        if (!LaggingActivity.class.isAssignableFrom(activityClass)) {
            throw new RuntimeException("LaggingActivity.start: activityClass must be a subclass of LaggingActivity.");
        }
        int activityId = LaggingActivity.put(activityObject);
        Intent intent = new Intent(parentContext, activityClass);
        intent.putExtra(ACTIVITY_ID, activityId);
        parentContext.startActivity(intent);
    }

    abstract void onCreate(Bundle var1, Object var2);

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.activityId = this.getIntent().getIntExtra(ACTIVITY_ID, 0);
        Object activityObject = LaggingActivity.get(this.activityId);
        if (activityObject == null) {
            this.finish();
        } else {
            this.onCreate(icicle, activityObject);
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        this.softDestroy = true;
    }

    protected void onDestroy() {
        if (!this.softDestroy) {
            LaggingActivity.remove(this.activityId);
        }
        super.onDestroy();
    }
}

