/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ia.android.sdk;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.sas.ia.android.sdk.Honeycomb;
import com.sas.ia.android.sdk.InterstitialWebBrowser;
import com.sas.ia.android.sdk.LaggingActivity;
import java.io.IOException;
import java.io.InputStream;

public class InterstitialWebActivity
extends LaggingActivity {
    private final String RES_PREFIX = "com/sas/ia/android/sdk/res/icons/";
    private final String RES_IC_MENU_FORWARD = "ic_menu_forward.png";
    private final String RES_IC_MENU_BACK = "ic_menu_back.png";
    private final String RES_IC_MENU_REFRESH = "ic_menu_refresh.png";
    private final String RES_BTN_CLOSE_NORMAL = "btn_close_normal.png";
    InterstitialWebBrowser browser = null;
    boolean firstStart = true;
    WebView webView;
    private MenuItem backItem;
    private MenuItem forwardItem;
    private MenuItem refreshItem;
    private MenuItem closeItem;
    private ImageView backButton;
    private ImageView forwardButton;
    private ImageView refreshButton;
    private ImageView closeButton;
    private ProgressBar progressBar;

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    void onCreate(Bundle icicle, Object activityObject) {
        this.browser = (InterstitialWebBrowser)activityObject;
        Honeycomb.showActionBar(this, false);
        this.backButton = new ImageView((Context)this);
        this.backButton.setId(ImageView.generateViewId());
        RelativeLayout.LayoutParams backLayout = new RelativeLayout.LayoutParams(-2, -2);
        backLayout.addRule(9);
        backLayout.setMargins(10, 0, 10, 0);
        this.backButton.setLayoutParams((ViewGroup.LayoutParams)backLayout);
        this.backButton.setImageDrawable(this.getEmbeddedGraphic("ic_menu_back.png"));
        this.backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InterstitialWebActivity.this.back();
            }
        });
        this.forwardButton = new ImageView((Context)this);
        this.forwardButton.setId(ImageView.generateViewId());
        RelativeLayout.LayoutParams forwardLayout = new RelativeLayout.LayoutParams(-2, -2);
        forwardLayout.addRule(1, this.backButton.getId());
        forwardLayout.setMargins(10, 0, 10, 0);
        this.forwardButton.setLayoutParams((ViewGroup.LayoutParams)forwardLayout);
        this.forwardButton.setImageDrawable(this.getEmbeddedGraphic("ic_menu_forward.png"));
        this.forwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InterstitialWebActivity.this.forward();
            }
        });
        this.refreshButton = new ImageView((Context)this);
        RelativeLayout.LayoutParams refreshLayout = new RelativeLayout.LayoutParams(-2, -2);
        refreshLayout.addRule(1, this.forwardButton.getId());
        refreshLayout.setMargins(10, 0, 10, 0);
        this.refreshButton.setLayoutParams((ViewGroup.LayoutParams)refreshLayout);
        this.refreshButton.setImageDrawable(this.getEmbeddedGraphic("ic_menu_refresh.png"));
        this.refreshButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InterstitialWebActivity.this.refresh();
            }
        });
        this.closeButton = new ImageView((Context)this);
        RelativeLayout.LayoutParams closeLayout = new RelativeLayout.LayoutParams(-2, -2);
        closeLayout.addRule(11);
        this.closeButton.setLayoutParams((ViewGroup.LayoutParams)closeLayout);
        this.closeButton.setImageDrawable(this.getEmbeddedGraphic("btn_close_normal.png"));
        this.closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InterstitialWebActivity.this.finish();
            }
        });
        this.progressBar = new ProgressBar((Context)this, null, 16842872);
        RelativeLayout.LayoutParams progressLayout = new RelativeLayout.LayoutParams(-1, 8);
        progressLayout.addRule(3, 1);
        progressLayout.setMargins(0, -4, 0, 0);
        this.progressBar.setLayoutParams((ViewGroup.LayoutParams)progressLayout);
        RelativeLayout buttonView = new RelativeLayout((Context)this);
        buttonView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        buttonView.addView((View)this.backButton);
        buttonView.addView((View)this.forwardButton);
        buttonView.addView((View)this.refreshButton);
        buttonView.addView((View)this.closeButton);
        buttonView.addView((View)this.progressBar);
        this.webView = new WebView((Context)this);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.webView.getSettings().setUseWideViewPort(true);
        this.webView.getSettings().setBuiltInZoomControls(true);
        Honeycomb.setLoadWithOverviewMode(this.webView);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        this.webView.setWebViewClient((WebViewClient)new InterstitialWebClient());
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int progress) {
                InterstitialWebActivity.this.progressBar.setProgress(progress);
            }
        });
        this.adjustButtons();
        LinearLayout view = new LinearLayout((Context)this);
        view.setOrientation(1);
        view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        view.addView((View)buttonView);
        view.addView((View)this.webView);
        this.setContentView((View)view, view.getLayoutParams());
        this.browser.onOpen(this);
    }

    @Override
    protected void onDestroy() {
        if (this.browser != null) {
            this.webView.stopLoading();
            this.webView.setWebViewClient(null);
            if (!this.softDestroy) {
                this.browser.onClose();
            }
        }
        super.onDestroy();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        this.backItem = menu.add((CharSequence)"Back");
        this.backItem.setIcon(this.getEmbeddedGraphic("ic_menu_back.png"));
        this.forwardItem = menu.add((CharSequence)"Forward");
        this.forwardItem.setIcon(this.getEmbeddedGraphic("ic_menu_forward.png"));
        this.refreshItem = menu.add((CharSequence)"Refresh");
        this.refreshItem.setIcon(this.getEmbeddedGraphic("ic_menu_refresh.png"));
        this.closeItem = menu.add((CharSequence)"Close");
        this.closeItem.setIcon(this.getEmbeddedGraphic("btn_close_normal.png"));
        this.adjustButtons();
        return super.onCreateOptionsMenu(menu);
    }

    protected void onStart() {
        super.onStart();
        if (this.firstStart) {
            this.firstStart = false;
            this.webView.loadUrl(this.browser.getUrl());
        }
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        if (item == this.backItem) {
            this.back();
            return true;
        }
        if (item == this.forwardItem) {
            this.forward();
            return true;
        }
        if (item == this.refreshItem) {
            this.refresh();
            return true;
        }
        if (item == this.closeItem) {
            this.finish();
            return true;
        }
        return super.onMenuItemSelected(featureId, item);
    }

    public void onBackPressed() {
        this.back();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    private void showError(int errorCode, String description, String failingUrl) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)"Cannot load web page");
        builder.setMessage((CharSequence)description);
        builder.setCancelable(false);
        builder.setPositiveButton(17039370, null);
        builder.create().show();
    }

    private void adjustButtons() {
        if (this.forwardItem != null) {
            this.forwardItem.setEnabled(this.webView.canGoForward());
        }
        if (Honeycomb.running()) {
            Honeycomb.setViewAlpha((View)this.forwardButton, this.webView.canGoForward() ? 1.0f : 0.6f);
        } else {
            this.forwardButton.setVisibility(this.webView.canGoForward() ? 0 : 4);
        }
    }

    private void back() {
        if (this.webView.canGoBack()) {
            this.webView.goBack();
        } else {
            this.finish();
        }
    }

    private void forward() {
        if (this.webView.canGoForward()) {
            this.webView.goForward();
        }
    }

    private void refresh() {
        this.webView.reload();
    }

    private Drawable getEmbeddedGraphic(String path) {
        InputStream stream = this.getClassLoader().getResourceAsStream("com/sas/ia/android/sdk/res/icons/" + path);
        if (stream != null) {
            Bitmap bmp = BitmapFactory.decodeStream((InputStream)stream);
            return new BitmapDrawable(this.getResources(), bmp);
        }
        try {
            Bitmap bmp = BitmapFactory.decodeStream((InputStream)this.getAssets().open(path));
            return new BitmapDrawable(this.getResources(), bmp);
        }
        catch (IOException e) {
            Log.e((String)"InterstitialWebActivity", (String)("Error loading resource: " + e), (Throwable)e);
            return null;
        }
    }

    private class InterstitialWebClient
    extends WebViewClient {
        private InterstitialWebClient() {
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            InterstitialWebActivity.this.progressBar.setProgress(0);
            InterstitialWebActivity.this.progressBar.setVisibility(0);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            InterstitialWebActivity.this.progressBar.setVisibility(4);
            InterstitialWebActivity.this.adjustButtons();
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            super.onReceivedError(view, request, error);
            InterstitialWebActivity.this.progressBar.setVisibility(4);
            InterstitialWebActivity.this.adjustButtons();
            if (Build.VERSION.SDK_INT >= 23) {
                InterstitialWebActivity.this.showError(error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
            } else {
                Log.w((String)InterstitialWebActivity.class.getSimpleName(), (String)("Unable to process error, unexpected platform version " + Build.VERSION.SDK_INT));
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            Uri uri = request.getUrl();
            String scheme = uri.getScheme();
            if (!scheme.equals("http") && !scheme.equals("https")) {
                try {
                    Intent browserIntent = new Intent("android.intent.action.VIEW", uri);
                    InterstitialWebActivity.this.startActivity(browserIntent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
    }
}

