/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ia.android.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.sas.ia.android.sdk.DisplayHelper;
import com.sas.ia.android.sdk.InterstitialActivity;
import com.sas.ia.android.sdk.LaggingActivity;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;

public class Interstitial {
    protected WeakReference<Delegate> delegate = new WeakReference<Object>(null);
    protected Delegate benignDelegate = new Delegate(){

        @Override
        public void onVisibilityChange(boolean visible) {
        }

        @Override
        public void onConfigurationChanged(Configuration newConfiguration) {
        }

        @Override
        public void close() {
            Interstitial.this.doClose();
        }
    };
    private Context parentContext;
    protected Object strongReference;
    protected ViewGroup view;
    protected View subView;
    private ImageView closeButton;
    protected boolean usesCloseArea = true;
    protected boolean usesCloseIcon = true;
    public Rect layoutRect = null;
    protected int orientation = -1;
    private static final int CLOSE_AREA_SIZE_DIPS = 50;
    private WeakReference<InterstitialActivity> activity = new WeakReference<Object>(null);

    public Interstitial(View subView, Context parentContext, Object strongReference, Delegate delegate) {
        this.subView = subView;
        this.parentContext = parentContext;
        this.strongReference = strongReference;
        this.delegate = new WeakReference<Delegate>(delegate);
    }

    public Activity getActivity() {
        return (Activity)this.activity.get();
    }

    protected Delegate getDelegate() {
        Delegate strongDelegate = (Delegate)this.delegate.get();
        if (strongDelegate == null) {
            strongDelegate = this.benignDelegate;
        }
        return strongDelegate;
    }

    public View getView() {
        return this.view;
    }

    public boolean isFullScreen() {
        return this.layoutRect == null;
    }

    private RelativeLayout.LayoutParams getCloseLayout() {
        DisplayHelper displayHelper = new DisplayHelper(this.getActivity());
        int closeSize = displayHelper.dipsToPixels(50);
        RelativeLayout.LayoutParams closeLayout = new RelativeLayout.LayoutParams(closeSize, closeSize);
        closeLayout.addRule(10);
        closeLayout.addRule(11);
        return closeLayout;
    }

    protected void setCloseImage() {
        Activity strongActivity = this.getActivity();
        if (strongActivity == null) {
            return;
        }
        if (this.usesCloseIcon) {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream("com/sas/ia/android/sdk/res/icons/aim_close.png");
            if (stream != null) {
                this.closeButton.setImageDrawable((Drawable)new BitmapDrawable(this.parentContext.getResources(), stream));
            } else {
                try {
                    stream = this.parentContext.getAssets().open("aim_close.png");
                    this.closeButton.setImageDrawable((Drawable)new BitmapDrawable(this.parentContext.getResources(), stream));
                }
                catch (IOException e) {
                    Log.e((String)"Interstitial", (String)("Error loading resources: " + e.getMessage()), (Throwable)e);
                }
            }
        } else {
            this.closeButton.setImageDrawable(null);
        }
    }

    protected void setUsesCloseIcon(boolean usesCloseIcon) {
        this.usesCloseIcon = usesCloseIcon;
        this.setCloseImage();
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        if (this.getActivity() == null) {
            return;
        }
        this.getActivity().setRequestedOrientation(orientation);
    }

    public void onConfigurationChanged(Configuration newConfiguration) {
        this.getDelegate().onConfigurationChanged(newConfiguration);
    }

    public void show() {
        if (this.getActivity() != null) {
            return;
        }
        LaggingActivity.start(this.parentContext, InterstitialActivity.class, this);
    }

    protected void onOpen(InterstitialActivity activity) {
        this.activity = new WeakReference<InterstitialActivity>(activity);
        activity.setRequestedOrientation(this.orientation);
        this.view = new RelativeLayout((Context)activity);
        RelativeLayout.LayoutParams params = null;
        if (this.isFullScreen()) {
            params = new RelativeLayout.LayoutParams(-1, -1);
        } else {
            params = new RelativeLayout.LayoutParams(this.layoutRect.width(), this.layoutRect.height());
            params.leftMargin = this.layoutRect.left;
            params.topMargin = this.layoutRect.top;
        }
        this.view.setLayoutParams((ViewGroup.LayoutParams)params);
        RelativeLayout contentView = new RelativeLayout((Context)activity);
        RelativeLayout.LayoutParams viewLayout = (RelativeLayout.LayoutParams)this.subView.getLayoutParams();
        viewLayout.addRule(13);
        contentView.setLayoutParams((ViewGroup.LayoutParams)viewLayout);
        this.subView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        contentView.addView(this.subView);
        this.view.addView((View)contentView);
        if (this.usesCloseArea) {
            this.closeButton = new ImageView((Context)activity);
            this.closeButton.setScaleType(ImageView.ScaleType.FIT_XY);
            this.closeButton.setLayoutParams((ViewGroup.LayoutParams)this.getCloseLayout());
            this.setCloseImage();
            this.closeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Interstitial.this.close();
                }
            });
            contentView.addView((View)this.closeButton);
        }
    }

    public void close() {
        this.getDelegate().close();
    }

    public void doClose() {
        Activity strongActivity = this.getActivity();
        if (strongActivity == null) {
            return;
        }
        this.view.setVisibility(4);
        this.view.removeView(this.subView);
        strongActivity.finish();
        this.strongReference = null;
    }

    protected void onDestroy() {
        if (this.subView.getParent() != null) {
            this.view.removeView(this.subView);
        }
        this.activity.clear();
        this.view = null;
        this.closeButton = null;
    }

    protected void onVisibilityChange(boolean visible) {
        this.getDelegate().onVisibilityChange(visible);
    }

    public static interface Delegate {
        public void onVisibilityChange(boolean var1);

        public void onConfigurationChanged(Configuration var1);

        public void close();
    }
}

