/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ia.android.sdk;

import android.app.Activity;
import android.graphics.Rect;
import android.os.IBinder;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;

public class DisplayHelper {
    private final float density;
    private final Activity activity;

    DisplayHelper(Activity activity) {
        this.activity = activity;
        Display display = activity.getWindowManager().getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        this.density = metrics.density;
    }

    public final int dipsToPixels(int dips) {
        return Math.round((float)dips * this.density);
    }

    public final int pixelsToDips(int pixels) {
        return Math.round((float)pixels / this.density);
    }

    public final Rect dipsToPixels(Rect rectDips) {
        return new Rect(this.dipsToPixels(rectDips.left), this.dipsToPixels(rectDips.top), this.dipsToPixels(rectDips.right), this.dipsToPixels(rectDips.bottom));
    }

    public final Rect pixelsToDips(Rect rectPixels) {
        return new Rect(this.pixelsToDips(rectPixels.left), this.pixelsToDips(rectPixels.top), this.pixelsToDips(rectPixels.right), this.pixelsToDips(rectPixels.bottom));
    }

    private Rect viewInWindowRect(View view) {
        int[] viewOrigin = new int[]{0, 0};
        IBinder token = view.getWindowToken();
        if (token != null) {
            view.getLocationOnScreen(viewOrigin);
        }
        return this.pixelsToDips(new Rect(viewOrigin[0], viewOrigin[1], viewOrigin[0] + view.getWidth(), viewOrigin[1] + view.getHeight()));
    }

    public final Rect viewRect(View view) {
        Rect appRect = this.viewInWindowRect((View)this.topView());
        Rect viewRect = this.viewInWindowRect(view);
        int originX = viewRect.left - appRect.left;
        int originY = viewRect.top - appRect.top;
        return new Rect(originX, originY, originX + this.pixelsToDips(view.getWidth()), originY + this.pixelsToDips(view.getHeight()));
    }

    public final Rect screenRect() {
        Display display = this.activity.getWindowManager().getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        return new Rect(0, 0, this.pixelsToDips(metrics.widthPixels), this.pixelsToDips(metrics.heightPixels));
    }

    public final ViewGroup topView() {
        Activity topActivity = this.activity;
        Activity parentActivity = topActivity.getParent();
        while (parentActivity != null) {
            topActivity = parentActivity;
            parentActivity = topActivity.getParent();
        }
        return (ViewGroup)topActivity.findViewById(0x1020002);
    }

    public final Rect appRect() {
        Rect appInWindowRect = this.viewInWindowRect((View)this.topView());
        return new Rect(0, 0, appInWindowRect.width(), appInWindowRect.height());
    }
}

