/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ia.android.sdk;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;

public class ContentLoadingTask
implements Runnable {
    private String url;
    private String userAgent;
    private ContentLoadingListener callback;
    private boolean cancel = false;

    public ContentLoadingTask(String url, String userAgent, ContentLoadingListener callback) {
        this.url = url;
        this.userAgent = userAgent;
        this.callback = callback;
    }

    public void cancel() {
        this.cancel = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Result result = new Result();
        try {
            URL requestUrl = new URL(this.url);
            HttpURLConnection urlConnection = (HttpURLConnection)requestUrl.openConnection();
            urlConnection.setRequestProperty("User-Agent", this.userAgent);
            try {
                char[] buffer = new char[10000];
                StringBuilder out = new StringBuilder();
                try (InputStreamReader in = new InputStreamReader(urlConnection.getInputStream(), "UTF-8");){
                    while (!this.cancel) {
                        int rsz = ((Reader)in).read(buffer, 0, buffer.length);
                        if (rsz < 0) {
                            break;
                        }
                        out.append(buffer, 0, rsz);
                    }
                }
                result.pageContent = out.toString();
            }
            catch (IOException ex) {
                result.errorMessage = ex.toString();
            }
            finally {
                urlConnection.disconnect();
            }
        }
        catch (IOException ex) {
            result.errorMessage = ex.toString();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            result.errorMessage = ex.toString();
        }
        this.onPostExecute(result);
    }

    protected void onPostExecute(Result result) {
        String pageContent = result.pageContent;
        if (pageContent == null || pageContent.isEmpty()) {
            this.callback.loadComplete(pageContent, result.errorMessage);
            return;
        }
        String headScriptTag = "<script type=\"text/javascript\">\nwindow.addEventListener(\"load\",function() {\nwindow.SASIA_MRAID.receiveInnerHTML(document.body.innerHTML);\n},false);\n</script>\n";
        int headLoc = pageContent.indexOf("<head");
        if (headLoc < 0) {
            String head = "<head>\n" + headScriptTag + "</head>\n";
            int bodyLoc = pageContent.indexOf("<body");
            pageContent = bodyLoc < 0 ? head + "<body style=\"margin: 0; padding: 0;\">\n" + pageContent + "</body>\n" : pageContent.substring(0, bodyLoc) + head + pageContent.substring(bodyLoc);
        } else if ((headLoc = pageContent.indexOf(">", headLoc)) >= 0) {
            pageContent = pageContent.substring(0, headLoc + 1) + "\n" + headScriptTag + pageContent.substring(headLoc + 1);
        }
        this.callback.loadComplete(pageContent, result.errorMessage);
    }

    public static interface ContentLoadingListener {
        public void loadComplete(String var1, String var2);
    }

    protected class Result {
        String pageContent = "";
        String errorMessage;

        protected Result() {
        }
    }
}

