/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ia.android.sdk;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.RelativeLayout;
import com.sas.ia.android.sdk.AdDelegate;
import com.sas.ia.android.sdk.AdRequest;
import com.sas.ia.android.sdk.MRAIDWebView;
import com.sas.ia.android.sdk.TagProcessResult;
import java.lang.ref.WeakReference;
import java.text.NumberFormat;

public abstract class AbstractAd
extends RelativeLayout {
    private final String TAG = AbstractAd.class.getSimpleName();
    protected WeakReference<AdDelegate> delegate = new WeakReference<Object>(null);
    protected AdDelegate benignDelegate = new AdDelegate();
    protected MRAIDWebView mraidView;
    private AdMRAIDWebViewDelegate mraidViewDelegate;
    private boolean loaded = false;
    private boolean defaultLoaded = false;
    private Integer fcid = null;

    public AbstractAd(Context context) {
        super(context);
        this.initView(context);
    }

    public AbstractAd(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public AbstractAd(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    private void initView(Context context) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.e((String)this.TAG, (String)("Mobile spots not supported on Android OS Version: " + Build.VERSION.SDK_INT));
            return;
        }
        Log.d((String)AbstractAd.class.getSimpleName(), (String)"Initializing AbstractAd");
        this.benignDelegate = new AdDelegate();
        this.mraidViewDelegate = new AdMRAIDWebViewDelegate();
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.createMraidView(context);
    }

    private void createMraidView(Context context) {
        this.mraidView = new MRAIDWebView(context, this.mraidViewDelegate);
        this.addView((View)this.mraidView);
    }

    private void reloadMraidView() {
        this.removeView((View)this.mraidView);
        this.createMraidView(this.getContext());
    }

    public AdDelegate getDelegate() {
        AdDelegate strongDelegate = (AdDelegate)this.delegate.get();
        if (strongDelegate == null) {
            strongDelegate = this.benignDelegate;
        }
        return strongDelegate;
    }

    public void setDelegate(AdDelegate delegate) {
        this.delegate = new WeakReference<AdDelegate>(delegate);
    }

    public Activity getParentActivity() {
        return this.mraidView.getActivity();
    }

    public void onVisibilityChange(boolean newVisible) {
        this.mraidView.onVisibilityChange(newVisible);
    }

    public WebView getWebView() {
        return this.mraidView.webView;
    }

    public void setScale(int scale) {
        this.mraidView.webView.setInitialScale(scale);
    }

    public String executeJavaScript(String js, String jsStringExpression) {
        return this.mraidView.executeJavaScript(js, jsStringExpression);
    }

    public Integer fcid() {
        return this.fcid;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isDefaultLoaded() {
        return this.defaultLoaded;
    }

    public void load(AdRequest adRequest) {
        this.defaultLoaded = false;
        this.loaded = false;
        this.fcid = null;
        this.mraidView.load(adRequest.toString());
    }

    protected void closeView() {
    }

    public void close() {
        this.mraidView.close();
    }

    protected void useCustomClose(boolean customClose) {
    }

    public boolean isActionInBrowser() {
        return this.mraidView.isActionInBrowser();
    }

    public void setActionInBrowser(boolean actionInBrowser) {
        this.mraidView.setActionInBrowser(actionInBrowser);
    }

    public boolean isActionInProgress() {
        return this.mraidView.isActionInProgress();
    }

    public Activity getActionActivity() {
        return this.mraidView.getActionActivity();
    }

    public void cancelAction() {
        this.mraidView.cancelAction();
    }

    protected TagProcessResult processAdHTML(String htmlContent) {
        return TagProcessResult.success;
    }

    private class AdMRAIDWebViewDelegate
    implements MRAIDWebView.Delegate {
        private AdMRAIDWebViewDelegate() {
        }

        @Override
        public void onLoaded(MRAIDWebView mraidView) {
            String adContents = mraidView.htmlContent();
            AbstractAd.this.defaultLoaded = adContents.contains("/FCID=-") || adContents.contains("/FCID=0");
            AbstractAd.this.loaded = !AbstractAd.this.defaultLoaded;
            if (AbstractAd.this.defaultLoaded) {
                AbstractAd.this.fcid = 0;
            } else {
                int fcidPos = adContents.indexOf("/FCID=");
                if (fcidPos >= 0) {
                    try {
                        NumberFormat nf = NumberFormat.getIntegerInstance();
                        Number n = nf.parse(adContents.substring(fcidPos + 6));
                        AbstractAd.this.fcid = n.intValue();
                    }
                    catch (Exception e) {
                        AbstractAd.this.fcid = -1;
                    }
                } else {
                    AbstractAd.this.fcid = -1;
                }
            }
            if (AbstractAd.this.defaultLoaded) {
                AbstractAd.this.getDelegate().onDefaultLoaded(AbstractAd.this);
            } else {
                TagProcessResult processResult = AbstractAd.this.processAdHTML(adContents);
                if (processResult != TagProcessResult.success) {
                    AbstractAd.this.getDelegate().onLoadFailed(AbstractAd.this, processResult.ordinal(), processResult.toString(), null);
                    return;
                }
                AbstractAd.this.getDelegate().onLoaded(AbstractAd.this);
            }
        }

        @Override
        public void onLoadFailed(MRAIDWebView mraidView, int errorCode, String description, String failingUrl) {
            AbstractAd.this.getDelegate().onLoadFailed(AbstractAd.this, errorCode, description, failingUrl);
        }

        @Override
        public void useCustomClose(MRAIDWebView mraidView, boolean customClose) {
            AbstractAd.this.useCustomClose(customClose);
        }

        @Override
        public boolean willClose(MRAIDWebView mraidView) {
            return AbstractAd.this.getDelegate().willClose(AbstractAd.this);
        }

        @Override
        public void onClosed(MRAIDWebView mraidView) {
            AbstractAd.this.getDelegate().onClosed(AbstractAd.this);
        }

        @Override
        public boolean willBeginAction(MRAIDWebView mraidView, String url) {
            return AbstractAd.this.getDelegate().willBeginAction(AbstractAd.this, url);
        }

        @Override
        public void onActionFinished(MRAIDWebView mraidView) {
            AbstractAd.this.getDelegate().onActionFinished(AbstractAd.this);
        }

        @Override
        public boolean willExpand(MRAIDWebView mraidView, String url) {
            return AbstractAd.this.getDelegate().willExpand(AbstractAd.this, url);
        }

        @Override
        public void onExpandFinished(MRAIDWebView mraidView) {
            AbstractAd.this.getDelegate().onExpandFinished(AbstractAd.this);
        }

        @Override
        public boolean willResize(MRAIDWebView mraidView, Rect size) {
            return AbstractAd.this.getDelegate().willResize(AbstractAd.this, size);
        }

        @Override
        public void onResizeFinished(MRAIDWebView mraidView) {
            AbstractAd.this.getDelegate().onResizeFinished(AbstractAd.this);
        }
    }
}

