/* Copyright (c) 2000 by SAS Institute Inc., Cary, NC 27513 */

import java.applet.Applet;

import java.awt.*;
import java.lang.reflect.*;
import java.security.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 * An example applet which requires special access to run properly.  Used to demonstrate applet signing.
 *
 * @author Joel Kamentz, Joel.Kamentz@sas.com
 * @history 2000/09/20 created
 */
public class PropsApplet extends Applet
{
	// instance stuff
	protected JLabel m_status;
	protected JTable m_table;

	public void init() {
		setLayout( new BorderLayout() );

		m_status = new JLabel("init");
		add(m_status, BorderLayout.NORTH);

		m_table = new JTable();
		JScrollPane sp = new JScrollPane(m_table);
		add(sp, BorderLayout.CENTER);
	}

	public void start() {
		m_status.setText("start");

		// if we're signed, exercise it with a doPrivileged call, just in case
		// we're called from unsigned code.
		AccessController.doPrivileged( new PrivilegedAction() {
			public Object run() {
				try {
					updateTable();
					m_status.setText("Success");
				} catch (SecurityException se) {
					m_status.setText("SecurityException");
				} catch (Exception ex) {
					String temp = ex + ", msg = " + ex.getMessage();
					m_status.setText(temp);
					System.out.println(temp);
					ex.printStackTrace();
				}

				return null; // effectively a void method
			}
		} );
	}

	// this method needs to run within a priviledged block
	protected void updateTable()
		throws NoSuchFieldException, IllegalAccessException
	{
		// In order to list everything, we'll need to check the parent / default
		// Properties as well.  However, it's stored in a protected member.
		Field defaults = Properties.class.getDeclaredField("defaults");
		defaults.setAccessible(true);

		Map map = new TreeMap(); // sorts the properties for us
		Properties props = System.getProperties();
		for ( ; props != null; props = (Properties) defaults.get(props) ) {
			Iterator it = props.entrySet().iterator();
			while ( it.hasNext() ) {
				Map.Entry entry = (Map.Entry) it.next();
				Object key = entry.getKey();
				if ( !map.containsKey(key) )
					map.put( key, entry.getValue() );
			}
		}

		// put all the data in a table model
		m_table.setModel( createTableModel(map) );
	} // updateTable

	protected TableModel createTableModel(Map map) {
		DefaultTableModel model = new DefaultTableModel();
		model.addColumn("Property");
		model.addColumn("Value");

		Iterator it = map.entrySet().iterator();
		Object[] row = new Object [2];
		while ( it.hasNext() ) {
			Map.Entry entry = (Map.Entry) it.next();
			row[0] = entry.getKey();
			row[1] = entry.getValue();
			model.addRow(row);
		}

		return model;
	}
}