ods _all_ close;

data class_unicode;
  attrib name length=$80 /* Ensure space for long escapes! */
         sex length=$40
         age label='(*ESC*){unicode "03B1"x} - (*ESC*){unicode "03B5"x}';
  set sashelp.class(obs=8);
if (_n_ = 2) then name = '(*ESC*){unicode "03B1"x} Alice';
if (_n_ = 4) then name = "(*ESC*){unicode '03A6'x}(*ESC*){unicode '00B2'x}";
if (sex = 'M') then sex = "(*ESC*){unicode '2642'x}";
if (sex = 'F') then sex = "(*ESC*){unicode '2640'x}";

run;

proc template;
  define statgraph sge_unicode;
    begingraph;
      entrytitle 'Unicode in Data Values';
      layout overlay / xaxisopts=(labelAttrs=(size=12 weight=bold));
        scatterPlot x=age y=height / name="sp1"
              group=sex dataLabel=name dataLabelAttrs=(size=14 weight=bold);
        discreteLegend "sp1" / title="Sex" valueAttrs=(size=15 weight=bold)
              location=inside halign=right valign=bottom;
      endlayout;
      entryfootnote halign=left 'Workaround: use ODS Graphics Editor (.sge) format !';
    endgraph;
  end;
run;

ods listing sge=on;
ods graphics / reset imagename='sge_unicode';
proc sgrender data=class_unicode template=sge_unicode;
run;
ods _all_ close;

