
proc template;                                                                
  define statgraph selections;
    dynamic upLimit "low end of high mpg"
            lowLimit "upper end of low mpg";
    begingraph / designHeight=600;
      EntryTitle "Vehicles with Extreme Highway MPG (2004) "; 
      layout lattice / rows=2 columnDataRange=union rowDataRange=union
                        rowGutter=3px;
        columnAxes;
          columnAxis / label="MSRP($)";
        endColumnAxes;
        rowAxes;
          rowAxis / label=eval(colLabel(mpg_highway));
          rowAxis / label=eval(colLabel(mpg_highway));
        endRowAxes;
        
        scatterPlot x=eval(ifn(mpg_highway >= upLimit, msrp, .))
                    y=eval(ifn(mpg_highway >= upLimit, mpg_highway, .)) / group=make
                    datalabel=model datalabelAttrs=(size=10);
        scatterPlot x=eval(ifn(mpg_highway <= lowLimit, msrp, .))
                    y=eval(ifn(mpg_highway <= lowLimit, mpg_highway, .)) / group=make
                    datalabel=model datalabelAttrs=(size=10);
      endlayout;
    endgraph;                                                               
  end;                                                                       
run;

* ods listing image_dpi=300 style=listing;
ods graphics / reset height=600px labelMax=600;
proc sgrender template=selections data=sashelp.cars;
  dynamic upLimit=44 lowLimit=16 ;
run;
