
/* Get the column's allocated length */
%let colName=name;
%let dsName=sashelp.class;
data _null_;
  set &dsName (obs=1);
  call symputx("&colName._colLen", vlength(&colName));
  %put DEBUG: "&colName._colLen" = &&&colName._colLen;
run;


/* Reallocate the name column to double its original length.
 * Copy an equal length of non-breaking space as a suffix, to push the value
 * to the left half.
 * For example: John =>  John....        ('.' represents nbsp!)
 */
data rjClass;
  /* update column length! */
  drop tmpLen;
  attrib name length = $ %eval(2 * &name_colLen);
  set sashelp.class;

  if name ne '' then do;
    tmpLen = length(strip(name));

    /* Append an equal length of non-breaking space, + 1 for pad */
    name = cats(name, repeat('A0'x, tmpLen+1));
  end;
run;

proc template;
  define statgraph rjText;
    beginGraph;
      entryTitle "Right-justified text";
      layout overlay;
        scatterPlot x=weight y=height;
        scatterPlot x=weight y=height /
                markerCharacter=name
                markerCharacterAttrs=(family="SAS Monospace" size=10);
      endLayout;
      entryFootnote halign=left "Uses non-breaking space";
    endGraph;
  end;
run;

/*--Draw the Graph--*/
ods graphics / reset imageName="rightJustText";
proc sgrender data=rjClass(obs=8) template=rjText;
run;

