proc template;
  define statgraph age_grp_expr;
    dynamic boundary="Cut off age for tweens";
    beginGraph;
      entryTitle "Groups using Expression";
      layout overlay;
        scatterPlot x=weight y=height / name="sp1"
              markerAttrs=(size=12 weight=bold)
              group=eval(ifc(age LT boundary, "tween", "teen"));
              ;
        discreteLegend "sp1" / title='Age Group' location=inside
              hAlign=right vAlign=bottom;
      endLayout;
      entryFootnote halign=left 'group=eval(ifc(age LT boundary, "tween", "teen"))';
    endGraph;
  end;
run;

* ods listing style=analysis;
ods graphics / reset;
proc sgrender data=sashelp.class template=age_grp_expr;
dynamic boundary=14;
run;
