/* SAS TRTH API Macros v1.4 */
%put NOTE: SAS TRTH API v1.4;

%macro exec(sec,date,starttime,endtime,reqtype,msgtype,fieldlist);

%auth

%if &tokenstatus=0 %then %do;
	%put ERROR: Authentication Failed;
	%put ERROR- Terminating;
	%return;
%end;

%verify(&sec,&date,&date)

data _NULL_;
	if input("&date",?? yymmdd10.)=. then call symputx('verified',0,'G');
	else call symputx('verified',1,'G');
run;

%if &verified=0 %then %do;
	%put ERROR: Security Verification Failed;
	%put ERROR: Verify input parameters and try again;
	%put ERROR- Terminating;
%end;

%submit

proc datasets lib=work nolist nowarn;
	delete VerifyRIC;
quit;

%mend exec;

%macro execftp(sec,startdate,starttime,enddate,endtime,reqtype,msgtype,fieldlist);

%auth

%if &tokenstatus=0 %then %do;
	%put ERROR: Authentication Failed;
	%put ERROR- Terminating;
	%return;
%end;

%verify(&sec,&startdate,&enddate)

data _NULL_;
	if input("&startdate",?? yymmdd10.)=. or input("&enddate",?? yymmdd10.)=. then call symputx('verified',0,'G');
	else call symputx('verified',1,'G');
run;

%if &verified=0 %then %do;
	%put ERROR: Security Verification Failed;
	%put ERROR: Verify input parameters and try again;
	%put ERROR- Terminating;
%end;

%submitftp

proc datasets lib=work nolist nowarn;
	delete VerifyRIC;
quit;

%mend execftp;

%macro makeds;
proc sql noprint;
	create table TRTH.gettypes 
		(GetName char(200))
	;
	insert into TRTH.gettypes values
		('AssetDomains') values
		('BondTypes') values
		('InstrumentTypes') values
		('Countries') values
		('CreditRatings') values
		('Currencies') values
		('Exchanges') values
		('FuturesDeliveryMonths') values
		('MessageTypes') values
		('OptionsExpiryMonths') values
		('Quota') values
		('RestrictedPEs')
	;
quit;

proc sql noprint;
	create table TRTH.reqtypes 
		(ReqName char(200))
	;
	insert into TRTH.reqtypes values
		('TimeAndSales') values
		('MarketDepth') values
		('NasdaqLevel2') values
		('Intraday') values
		('EndOfDay') values
		('RTCE') values
		('RTCEMarketDepth') values
		('Any')
	;
quit;

%if %sysfunc(exist(TRTH.FTPRequests))=0 %then %do;
	proc sql noprint;
		create table TRTH.FTPRequests (
			datetimestamp date informat=datetime22. format=datetime22.,
			sec char(200),
			startdate num informat=yymmdd8.,
			starttime num informat=time12.3 format=time12.3,
			enddate num informat=yymmdd8., 
			endtime num informat=time12.3 format=time12.3,
			reqtype char(200),
			msgtype char(200),
			fieldlist char(32767),
			reqID char(200)
			)
		;
	quit;
%end;

%mend makeds;

%macro assignments(_uid,_pw,_compexe);
%global XCMD;
proc sql noprint;
	select 
		case when setting="XCMD"
			then 1
		else 0
		end
	into :XCMD
	from dictionary.options
	where optname='XCMD'
	;
quit;

%if &XCMD=0 %then %do;
	%put WARNING: XCMD is not enabled.;
	%put WARNING- Manual data extraction will be required after submitting %nrstr(%getresults);
	%put WARNING- After submitting %nrstr(%getresults) see log for further details;
%end;

%if %sysevalf(%superq(_uid)= or 
				%superq(_pw)= or 
				(%superq(_compexe)= and &XCMD=1)
				, boolean) %then %do;
	%put ERROR: One or more input parameters are missing;
	%put ERROR- Macro terminating;
	%return;
%end;

%global uid pw mapdir outdir compexe;
%global url _lrecl token verified reqID TRTHData TRTHDatagz ftpurl;

%let uid=&_uid;
%let pw=&_pw;
%let mapdir=&TRTHdir.TRTHFiles\;;
%let outdir=&TRTHdir.TRTHOut\;
%let compexe=&_compexe;

%let url=https://trth-api.thomsonreuters.com/TRTHApi-5.7.2/services/TRTHApi;
%let _lrecl=102400000;

libname TRTH "&outdir";
options lrecl=max noxwait xmin;

%makeds
%mend assignments;

%macro fault(filename);
%local dsid dsidclose faultcode faultstring;
filename sxlemap "&mapdir.Fault.map";
libname &filename xml92 xmlmap=sxlemap access=readonly;

%let dsid=%sysfunc(open(&filename..Fault));
%let nobs=%sysfunc(attrn(&dsid,any));
%let dsidclose=%sysfunc(close(&dsid));

%if &nobs=1 %then %do;
	data _null_;
		set &filename..Fault;
		call symputx("faultcode",faultcode,"L");
		call symputx("faultstring",faultstring,"L");
		set &filename..detail;
		call symputx("string",string,"L");
	run;
	%put WARNING: faultcode- %superq(faultcode);
	%put WARNING- faultstring- %superq(faultstring);
	%if %sysevalf(%superq(string) ne ) %then %put WARNING- string- %superq(string);
	%let rc=0;
%end;
libname &filename clear;
filename sxlemap clear;
%mend fault;

%macro gettoken(uid,pw,tokenstatus);
%local loginstr nobs cleanup;
%if &tokenstatus=0 %then %do;
	 %let loginstr=%str(			<username>&uid</username><password>&pw</password>);	 
	 %let _sxlemap=&mapdir.Authentication.map;
	 %if %sysevalf(&token= ) %then %let cleanup=  %str(			<CleanUp/>);
%end;
%else %do; 
	 %let loginstr=%str(			<tokenId>&token</tokenId>);
%end;

filename auth_req temp;
filename auth_res temp;

data _null_;
	file auth_req;
	put '<?xml version="1.0" encoding="utf-8"?>'/
		'<soap:Envelope'/
		'	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'/
		'	xmlns:xsd="http://www.w3.org/2001/XMLSchema"'/
		'	xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">'/
		'	<soap:Header>'/
		'		<CredentialsHeader xmlns="http://types.webservice.tickhistory.thomsonreuters.com">'/
		"&loginstr"
		'		</CredentialsHeader>'/
		'	</soap:Header>'/
		'	<soap:Body>'/
		'		<GetSnapshotInfo/>'/
		"&cleanup"
		'	</soap:Body>'/
		'</soap:Envelope>'/
	;
run;

proc soap
	in=auth_req
	out=auth_res
	url="&url"
	envelope;
run;

filename auth_req clear;

%fault(auth_res)

filename sxlemap "&mapdir.Authentication.map";
libname auth_res xml92 xmlmap=sxlemap access=readonly;

%if &nobs=1 %then %put WARNING: Authentication Failed;
%else %if &tokenstatus=0 %then %do;
	proc sql noprint;
		select tokenID
		into :token
		from auth_res.CredentialsHeader
		;
	quit;
	%let rc=1;
%end;
%else %let rc=1;

libname auth_res clear;
filename sxlemap clear;
filename auth_res clear;

%mend gettoken;

%macro auth;
%global tokenstatus;
%local i rc;
%let i=0;
%do %until (&i=2 or &tokenstatus=1);
	%if %sysevalf(&token= ) or &tokenstatus=0 %then %let tokenstatus=0;
	%else %let tokenstatus=1;
	%gettoken(&uid,&pw,&tokenstatus)
	%let tokenstatus=&rc;
	%let i=%eval(&i+1);
	%if &tokenstatus ne 0 %then %put NOTE: Authentication Successful;
	%else %if &i<2 %then %put NOTE: Attempting to reauthenticate;
%end;
%mend auth;

%macro get(gettype,reqtype);

%auth

%local getreq msgreq rc;
%if &gettype=MessageTypes %then %let msgreq=1;
%if &msgreq=1 %then %do;
	%if %superq(reqtype)= %then %let reqtype=Any;
	%let getreq=%str(		<typ:GetMessageTypes><typ:requestType>&reqtype</typ:requestType></typ:GetMessageTypes>);
%end;
%else 
	%let getreq=%str(		<typ:Get&gettype/>);

filename get_req temp;
filename get_res temp lrecl=&_lrecl;

data _null_;
	file get_req;
	put '<?xml version="1.0" encoding="utf-8"?>'/
		'<soap:Envelope'/
		'	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'/
		'	xmlns:xsd="http://www.w3.org/2001/XMLSchema"'/
		'	xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"'/
		'	xmlns:typ="http://types.webservice.tickhistory.thomsonreuters.com">'/
		'	<soap:Header>'/
		'		<typ:CredentialsHeader>'/
		'			<typ:tokenId>'"&token"'</typ:tokenId>'/
		'		</typ:CredentialsHeader>'/
		'	</soap:Header>'/
		'	<soap:Body>'/
		"&getreq"
		'	</soap:Body>'/
		'</soap:Envelope>'/
	;
run;

proc soap
	in=get_req
	out=get_res
	url="&url"
	envelope;
run;

%fault(get_res)
%if &rc=0 %then %do;
	filename get_res clear;
	%return;
%end;

filename sxlemap "&mapdir.Get.map";
libname get_res xml92 xmlmap=sxlemap access=readonly;

data TRTH.&gettype;
%if &msgreq=1 %then %do;
	reqtype="&reqtype";
	merge get_res.MsgType get_res.MsgTypeFields;
	by key;
	drop key;
%end;
%else set get_res.&gettype;;
run;

libname get_res clear;
filename sxlemap clear;

proc print data=TRTH.&gettype;
run;
%mend get;

%macro verify(sec,datest,dateend);
%local rc;

%let verified=0;

filename ver_req temp;
filename ver_res temp lrecl=&_lrecl;

data _null_;
	file ver_req;
	put '<?xml version="1.0" encoding="utf-8"?>'/
		'<soap:Envelope'/
		'	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'/
		'	xmlns:xsd="http://www.w3.org/2001/XMLSchema"'/
		'	xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"'/
		'	xmlns:typ="http://types.webservice.tickhistory.thomsonreuters.com">'/
		'	<soap:Header>'/
		'		<typ:CredentialsHeader>'/
		'			<typ:tokenId>'"&token"'</typ:tokenId>'/
		'		</typ:CredentialsHeader>'/
		'	</soap:Header>'/
		'	<soap:Body>'/
		'		<typ:VerifyRICs>'/
		'			<typ:dateRange>'/
		'				<typ:start>'"&datest"'</typ:start>'/
		'				<typ:end>'"&dateend"'</typ:end>'/
		'			</typ:dateRange>'/
		'			<typ:instrumentList>'/
		'				<typ:instrument>'/
		'					<typ:code>'"&sec"'</typ:code>'/
		'				</typ:instrument>'/
		'			</typ:instrumentList>'/
		'			<typ:refData>true</typ:refData>'/
		'		</typ:VerifyRICs>'/
		'	</soap:Body>'/
		'</soap:Envelope>'/
	;
run;

proc soap
	in=ver_req
	out=ver_res
	url="&url"
	envelope;
run;

filename ver_req clear;

%fault(ver_res)
%if &rc=0 %then %do;
	filename ver_res clear;
	%return;
%end;

filename sxlemap "&mapdir.VerifyRICs.map";
libname ver_res xml92 xmlmap=sxlemap access=readonly;

proc sql noprint;
	select 'ver_res.'||memname
	into :memname separated by ' '
	from dictionary.tables
	where libname="VER_RES"
	;
quit;

data work.VerifyRIC;
	merge &memname;
run;

proc sql noprint;
	select 
		case when status="Verified"
			then 1
		else 0
		end
	into :verified
	from work.VerifyRIC
	;
quit;

libname ver_res clear;
filename sxlemap clear;
filename ver_res clear;
%mend verify;

%macro submit;
%local friendlynm list rc;
%let reqtype=%sysfunc(tranwrd(%superq(reqtype),%nrstr(&),%nrstr(&amp;)));
%let msgtype=%sysfunc(tranwrd(%superq(msgtype),%nrstr(&),%nrstr(&amp;)));
%let fieldlist=%sysfunc(tranwrd(%superq(fieldlist),%nrstr(&),%nrstr(&amp;)));
%let friendlynm=%sysfunc(catx(-,%sysfunc(compress(&sec,,nk)),%sysfunc(datetime(),B8601DT19.0)));
%let list=%sysfunc(tranwrd(%bquote(&fieldlist),%str(,),</typ:string><typ:string>));

filename sub_req temp;
filename sub_res temp lrecl=&_lrecl;

data _null_;
	file sub_req;
	put '<?xml version="1.0" encoding="utf-8"?>'/
		'<soap:Envelope'/
		'	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'/
		'	xmlns:xsd="http://www.w3.org/2001/XMLSchema"'/
		'	xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"'/
		'	xmlns:typ="http://types.webservice.tickhistory.thomsonreuters.com">'/
		'	<soap:Header>'/
		'		<typ:CredentialsHeader>'/
		'			<typ:tokenId>'"&token"'</typ:tokenId>'/
		'		</typ:CredentialsHeader>'/
		'	</soap:Header>'/
		'	<soap:Body>'/
		'      <typ:SubmitRequest>'/
		'         <typ:request>'/
		'            <typ:friendlyName>'"&friendlynm"'</typ:friendlyName>'/
		'            <typ:requestType>'"&reqtype"'</typ:requestType>'/
		'            <typ:instrument>'/
		'               <typ:code>'"&sec"'</typ:code>'/
		'            </typ:instrument>'/
		'            <typ:date>'"&date"'</typ:date>'/
		'            <typ:timeRange>'/
		'               <typ:start>'"&starttime"'</typ:start>'/
		'               <typ:end>'"&endtime"'</typ:end>'/
		'            </typ:timeRange>'/
		'            <typ:messageTypeList>'/
		'               <typ:messageType>'/
		'                  <typ:name>'"&msgtype"'</typ:name>'/
		'                  <typ:fieldList>'/
		'                     <typ:string>'"&list"'</typ:string>'/
		'                  </typ:fieldList>'/
		'               </typ:messageType>'/
		'            </typ:messageTypeList>'/
		'            <typ:requestInGMT>true</typ:requestInGMT>'/
		'            <typ:displayInGMT>true</typ:displayInGMT>'/
		'            <typ:disableHeader>false</typ:disableHeader>'/
		'            <!--Optional:-->'/
		'            <typ:marketDepth>0</typ:marketDepth>'/
		'            <typ:dateFormat>YYYYMMDD</typ:dateFormat>'/
		'            <typ:disableDataPersistence>false</typ:disableDataPersistence>'/
		'            <typ:includeCurrentRIC>false</typ:includeCurrentRIC>'/
		'            <typ:applyCorrections>false</typ:applyCorrections>'/
		'            <typ:displayMicroseconds>true</typ:displayMicroseconds>'/
		'         </typ:request>'/
		'      </typ:SubmitRequest>'/
		'	</soap:Body>'/
		'</soap:Envelope>'/
	;
run;

proc soap
	in=sub_req
	out=sub_res
	url="&url"
	envelope;
run;

filename sub_req clear;

%fault(sub_res)
%if &rc=0 %then %do;
	filename sub_res clear;
	%return;
%end;

data TRTH.VerifyRIC;
	set work.VerifyRIC;
run;

filename sxlemap "&mapdir.SubmitRequest.map";
libname sub_res xml92 xmlmap=sxlemap access=readonly;

proc sql noprint;
	select requestID
	into :reqID
	from sub_res.SubmitRequestResponse
	;
quit;

libname sub_res clear;
filename sub_res clear;
filename sxlemap clear;

%mend submit;

%macro getresults(reqID,attempts,wait);

%auth

%local status queuePosition ftp rc hasobs outdsn counter;
%let counter=0;
%let ftp=%scan(&reqID,-2,-);
%if &ftp=1 %then %do;
	%let outdsn=%scan(&reqID,-4,-)%scan(&reqID,-3,-);
	%let TRTHdata=&outdir.%scan(&reqID,2,-)-%scan(&reqID,3,-)-%scan(&reqID,4,-).csv;
	%let TRTHdatagz=&TRTHdata..gz;
	%let ftpurl=https://tickhistory.thomsonreuters.com/HttpPull/Download?user=&uid%nrstr(&pass)=&pw%nrstr(&file)=/api-results/%sysfunc(strip(&reqID)).csv.gz;
%end;
%else %do;
	%let outdsn=%scan(&reqID,-3,-)%scan(&reqID,-2,-);
	%let TRTHdata=&outdir.%scan(&reqID,2,-)-%scan(&reqID,3,-).csv;
	%let TRTHdatagz=&TRTHdata..gz;
%end;

%if %superq(wait)= %then %let wait=5;
%if %superq(attempts)= %then %let attempts=5;

filename get_req temp;
filename get_res temp lrecl=&_lrecl;

data _null_;
	file get_req;
	put '<?xml version="1.0" encoding="utf-8"?>'/
		'<soap:Envelope'/
		'	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'/
		'	xmlns:xsd="http://www.w3.org/2001/XMLSchema"'/
		'	xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"'/
		'	xmlns:typ="http://types.webservice.tickhistory.thomsonreuters.com">'/
		'	<soap:Header>'/
		'		<typ:CredentialsHeader>'/
		'			<typ:tokenId>'"&token"'</typ:tokenId>'/
		'		</typ:CredentialsHeader>'/
		'	</soap:Header>'/
		'	<soap:Body>'/
		'		<GetRequestResult>'/
		'			<requestID>'"&reqID"'</requestID>'/
		'		</GetRequestResult>'/
		'	</soap:Body>'/
		'</soap:Envelope>'/
	;
run;

%do %until (&status=Complete or &counter=&attempts);
	data _null_;
		hold=sleep(&wait);
	run;

	proc soap
		in=get_req
		out=get_res
		url="&url"
		envelope;
	run;

	%fault(get_res)
	%if &rc=0 %then %do;
		filename get_res clear;
		%return;
	%end;

	filename sxlemap "&mapdir.GetRequestResult.map";
	libname get_res xml92 xmlmap=sxlemap access=readonly;

	proc sql noprint;
		select status
			, queuePosition
		into :status, :queuePosition
		from get_res.result
		;
	quit;

	libname get_res clear;
	filename sxlemap clear;
	
	%if &status ne Complete %then %do;
		%put WARNING: Get results failed see details below:;
		%put WARNING- Status- &status;
		%put WARNING- Queue Position- &queuePosition; 
		%put WARNING- Attempt number %eval(&counter+1) of &attempts;
		%if %eval(&counter+1)=&attempts %then %do;
			%put WARNING- Maximum number of attempts reached;
			%put WARNING- Terminating execution;
		%end;
		%else
			%put WARNING- Resubmitting request in &wait second(s);
	%end;
	%else %put NOTE: Results successfully downloaded from TRTH;

	%let counter=%eval(&counter+1);
%end;

filename get_req clear;

%if &status=Complete %then %do;
	filename get_gz "&TRTHdatagz" lrecl=&_lrecl;

	%if &ftp=1 %then %do;
		filename get_ftp url "%superq(ftpurl)" lrecl=&_lrecl recfm=s;

		data _null_;
			infile get_ftp;
			input;
			file get_gz;
			put _infile_;
		run;
	%end;
	%else %do;
		filename get_out temp lrecl=&_lrecl;

	data _null_;
		length col1 $32764 str $32764;
		infile get_res column=position; 
		input @"<ns1:data>" dummy $char1. @; 
		start=position-1; 
		input @"</ns1:data>" dummy $char1. @; 
		end=position-1;
		stpointer=start;
		endpointer=end-11; 
		loops=ceil((endpointer-stpointer)/32764);
		call symputx('loops',loops,'G');
		file get_out dropover;
		do i=1 to loops;
			tmpdiff=min(endpointer-stpointer,32764);
			input @stpointer col1 $varying32764.tmpdiff @;
			str=repeat('=',32764);
			substr(str,1,tmpdiff)=substr(col1,1,tmpdiff);
			put str +(-1) @;
			output;
			stpointer=stpointer+32764;
		end;
	run;

	data _null_;
		infile get_out;
		file get_gz dropover;
		stpointer=1;
		do i=1 to &loops;
			input @stpointer col1 $base64x32764. @;
			put col1 +(-1) @;
			output;
			stpointer=stpointer+32764;
		end;
	run;

	filename get_out clear;
	%end;

	filename get_res clear;

	%if &XCMD=1 %then %do;
		x "'&compexe' e &TRTHdatagz -aoa -o&outdir";

		filename get_gz clear;
		
		%let hasobs=1;

		data _null_; 
			infile "&TRTHdata" pad end=last; 
			input a $;
			if last and _N_=1 then call symputx('hasobs',0,'L');
		run;

		%if &hasobs=1 %then %do;
			proc import datafile="&TRTHdata"
				out=work.&outdsn
				replace;
				getnames=yes;
				guessingrows=2147483647;
			run;

			proc sql noprint;
				select name
				into :date_header
				from dictionary.columns
				where libname='WORK'
					and memname="&outdsn"
					and name like 'Date%'
				;
			quit;

			data TRTH.&outdsn;
				retain _RIC &date_header;
				set work.&outdsn(rename=(&date_header=Old_Date));
				format &date_header date9.;
				&date_header=input(put(Old_Date,8.),yymmdd10.);
                drop Old_Date;
			run;

			proc datasets lib=work nolist nowarn;
				delete &outdsn;
			quit;
		%end;
		%else %do;
			%put WARNING: The uncompressed file has no observations.;
			%put WARNING- See &TRTHdata for further details.;
			%put WARNING- File has not been imported.;
		%end;
	%end;
	%else %do; 
		%put WARNING: XCMD is not enabled.;
		%put WARNING- Unable to uncompress file.;
		%put WARNING- Please manually extract &TRTHdatagz in the same directory and submit the following code.;
		%put WARNING- %str(	proc import datafile="&TRTHdata");
		%put WARNING- %str(		out=work.&outdsn);
		%put WARNING- %str(		replace;);
		%put WARNING- %str(		getnames=yes;);
		%put WARNING- %str(		guessingrows=2147483647;);
		%put WARNING- %str(	run;);
		%put WARNING- ;
		%put WARNING- %str(	proc sql noprint;);
		%put WARNING- %str(		select name);
		%put WARNING- %str(		into :date_header);
		%put WARNING- %str(		from dictionary.columns);
		%put WARNING- %str(		where libname='WORK');
		%put WARNING- %str(			and memname="&outdsn");
		%put WARNING- %str(			and name like 'Date%');
		%put WARNING- %str(		;);
		%put WARNING- %str(	quit;);
		%put WARNING- ;
		%put WARNING- %str(	data TRTH.&outdsn;);
		%put WARNING- %str(		retain _RIC &date_header;);
		%put WARNING- %str(		set work.&outdsn(rename=(&date_header=Old_Date)););
		%put WARNING- %str(		informat &date_header yymmdd8.;);
		%put WARNING- %str(		&date_header=Old_Date;);
		%put WARNING- %str(		drop Old_Date;);
		%put WARNING- %str(	run;);
		%put WARNING- ;
		%put WARNING- %str(	proc datasets lib=work nolist nowarn;);
		%put WARNING- %str(		delete &outdsn;);
		%put WARNING- %str(	quit;);
	%end;
%end;

%mend getresults;

%macro submitftp;
%local friendlynm list rc;
%let reqtype=%sysfunc(tranwrd(%superq(reqtype),%nrstr(&),%nrstr(&amp;)));
%let msgtype=%sysfunc(tranwrd(%superq(msgtype),%nrstr(&),%nrstr(&amp;)));
%let fieldlist=%sysfunc(tranwrd(%superq(fieldlist),%nrstr(&),%nrstr(&amp;)));
%let friendlynm=%sysfunc(catx(-,%sysfunc(compress(&sec,,nk)),%sysfunc(datetime(),B8601DT19.0)))-1;
%let list=%sysfunc(tranwrd(%bquote(&fieldlist),%str(,),</typ:string><typ:string>));

filename ftp_req temp;
filename ftp_res temp lrecl=&_lrecl;

data _null_;
	file ftp_req;
	put '<?xml version="1.0" encoding="utf-8"?>'/
		'<soap:Envelope'/
		'	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'/
		'	xmlns:xsd="http://www.w3.org/2001/XMLSchema"'/
		'	xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"'/
		'	xmlns:typ="http://types.webservice.tickhistory.thomsonreuters.com">'/
		'	<soap:Header>'/
		'		<typ:CredentialsHeader>'/
		'			<typ:tokenId>'"&token"'</typ:tokenId>'/
		'		</typ:CredentialsHeader>'/
		'	</soap:Header>'/
		'	<soap:Body>'/
		'		<typ:SubmitFTPRequest>'/
		'			<typ:request>'/
		'          		<typ:friendlyName>'"&friendlynm"'</typ:friendlyName>'/
		'            	<typ:requestType>'"&reqtype"'</typ:requestType>'/
		'				<typ:instrumentList>'/
		'            		<typ:instrument>'/
		'             			<typ:code>'"&sec"'</typ:code>'/
		'            		</typ:instrument>'/
		'				</typ:instrumentList>'/
		'				<typ:dateRange>'/
		'					<typ:start>'"&startdate"'</typ:start>'/
		'					<typ:end>'"&enddate"'</typ:end>'/
		'				</typ:dateRange>'/
		'				<typ:timeRange>'/
		'					<typ:start>'"&starttime"'</typ:start>'/
		'					<typ:end>'"&endtime"'</typ:end>'/
		'				</typ:timeRange>'/
		'            	<typ:messageTypeList>'/
		'             		<typ:messageType>'/
		'                  		<typ:name>'"&msgtype"'</typ:name>'/
		'                  		<typ:fieldList>'/
		'                     		<typ:string>'"&list"'</typ:string>'/
		'                  		</typ:fieldList>'/
		'               	</typ:messageType>'/
		'            	</typ:messageTypeList>'/
		'				<typ:requestInGMT>true</typ:requestInGMT>'/
		'				<typ:displayInGMT>true</typ:displayInGMT>'/
		'				<typ:marketDepth>0</typ:marketDepth>'/
		'				<typ:splitSize>50</typ:splitSize>'/
		'				<typ:delivery>Pull</typ:delivery>'/
		'				<typ:sortType>RICSequence</typ:sortType>'/
		'				<typ:fileFormat>Single</typ:fileFormat>'/
		'				<typ:dateFormat>YYYYMMDD</typ:dateFormat>'/
		'				<typ:disableDataPersistence>false</typ:disableDataPersistence>'/
		'				<typ:includeCurrentRIC>false</typ:includeCurrentRIC>'/
		'				<typ:applyCorrections>false</typ:applyCorrections>'/
		'				<typ:displayMicroseconds>true</typ:displayMicroseconds>'/
		'			</typ:request>'/
		'		</typ:SubmitFTPRequest>'/
		'	</soap:Body>'/
		'</soap:Envelope>'/
	;
run;

proc soap
	in=ftp_req
	out=ftp_res
	url="&url"
	envelope;
run;

filename ftp_req clear;

%fault(ftp_res)
%if &rc=0 %then %do;
	filename ftp_res clear;
	%return;
%end;

data TRTH.VerifyRIC;
	set work.VerifyRIC;
run;

filename sxlemap "&mapdir.SubmitRequest.map";
libname ftp_res xml92 xmlmap=sxlemap access=readonly;

proc sql noprint;
	select requestID
	into :reqID
	from ftp_res.SubmitFTPRequestResponse
	;
quit;

proc sql;
	insert into TRTH.FTPRequests values
	("%sysfunc(datetime(),datetime22.)"dt "&sec" %sysfunc(compress("&startdate",,nk)) "&starttime"t %sysfunc(compress("&enddate",,nk)) "&endtime"t "&reqtype" "&msgtype" "&fieldlist" "&reqID")
	;
quit;

libname ftp_res clear;
filename ftp_res clear;
filename sxlemap clear;

%mend submitftp;
