import requests
import pprint
import getopt
import sys
import pandas as pd

requests.packages.urllib3.disable_warnings()
# file deepcode ignore NoHardcodedCredentials: There are no hardcoded credentials.
# file deepcode ignore Ssrf: This file is not product.

# Example: python3 getScenarioParameterChanges.py -g <guid> -p https -s <server> -u foo -w password -o scenarioParameterChanges.xlsx -v True

flowGuid = ''
protocol = ''
host = ''
username = ''
password = ''
output_file = ''
verify = True

argumentList = sys.argv[1:]

options = "hfg:p:s:u:w:o:v:"
long_options = ["Help", "File", "Guid=", "Protocol=", "Server=", "User=", "Password=", "OutputFilename=", "Verify="]

try:
    arguments, values = getopt.getopt(argumentList, options, long_options)
    for currentArgument, currentValue in arguments:
        if currentArgument in ("-h", "--Help"):
            print("getScenarioParameterChanges.py -g <flowGuid> -p <protocol> -s <server> -u <user> -w <password> -o <output_file> -v <verify True/False>")
            sys.exit()
        elif currentArgument in ("-f", "--File"):
            print("filename:", sys.argv[0])
        elif currentArgument in ("-g", "--Guid"):
            flowGuid = currentValue
            print("FlowGuid:", flowGuid)
        elif currentArgument in ("-p", "--Protocol"):
            protocol = currentValue
            print("Protocol:", protocol)
        elif currentArgument in ("-s", "--Server"):
            host = currentValue
            print("Host:", host)
        elif currentArgument in ("-u", "--User"):
            username = currentValue
            print("User:", username)
        elif currentArgument in ("-w", "--Password"):
            password = currentValue
            print("Password: ****")
        elif currentArgument in ("-o", "--OutputFilename"):
            output_file = currentValue
            print("OutputFilename:", output_file)
        elif currentArgument in ("-v", "--Verify"):
            if currentValue == "False":
                verify = False
    print("Verify:", verify)
except getopt.error as err:
    print(str(err))


def getAction(headers, uri):
    url = protocol + "://" + host + uri
    headers = headers
    response = requests.get(url, headers=headers, verify=verify)
    return response


def isNotBlank(value):
    return bool(value and value.strip())


pp = pprint.PrettyPrinter(indent=4)

url = protocol + "://" + host + '/SASLogon/oauth/token'
headersGetAuth = {
    'Accept': 'application/json',
    'Content-Type': 'application/x-www-form-urlencoded'
}

data = 'grant_type=password&username=' + username + '&password=' + password
response = requests.post(url, auth=('sas.ec', ''), data=data, headers=headersGetAuth, verify=verify)
print("login response status code: %d" % response.status_code)
access_token = response.json()["access_token"]
print('Token: ' + access_token[:20] + ' ...')

url = protocol + "://" + host + "/svi-vsd-service/flows/" + flowGuid + "/actions"
headersGetActions = {
    'Authorization': 'Bearer ' + access_token,
    'Accept': 'application/vnd.sas.collection+json',
    'Accept-Item': 'application/vnd.sas.investigate.action.summary'
}

changeList = []
response = requests.get(url, headers=headersGetActions, verify=verify)
data = response.json()
actions = data["items"]


def getParameterValueChanges():
    global changesNew
    changesNew = {}
    for change in changes.items():
        changesNew[change[0]] = change[1]
    rows = paramValueChangeItem['rows']
    changesNew['oldValue'] = rows[0][1]['value']
    changesNew['newValue'] = rows[0][2]['value']
    changesNew['changeType'] = 'Parameter edited'

def getParameterValues():
    global paramValueChangeItem
    for paramValueItem in paramValues['items']:
        if isNotBlank(paramValueItem['label']):
            changes["segment"] = paramValueItem['label']
        for paramValueChangeItem in paramValueItem['items']:
            getParameterValueChanges()
            changeList.append(changesNew)

def getParameterValueAdded(parametersAdded, parametersDeleted):
    addedParameterValues = []
    deletedParameterValues = []
    for parameter in parametersAdded:
        for value in parameter:
            addedParameterValues.append(value[0]['value'])
    for parameter in parametersDeleted:
        for value in parameter:
            deletedParameterValues.append(value[0]['value'])
    s = set(deletedParameterValues)
    diff = [x for x in addedParameterValues if x not in s]
    for addedParam in diff:
        changesNew = {}
        for change in changes.items():
            changesNew[change[0]] = change[1]
        changesNew['changeType'] = 'Parameter added'
        changesNew['newValue'] = addedParam
        changeList.append(changesNew)

def getParameterValueDeleted(parametersAdded, parametersDeleted):
    addedParameterValues = []
    deletedParameterValues = []
    for parameter in parametersAdded:
        for value in parameter:
            addedParameterValues.append(value[0]['value'])
    for parameter in parametersDeleted:
        for value in parameter:
            deletedParameterValues.append(value[0]['value'])
    s = set(addedParameterValues)
    diff = [x for x in deletedParameterValues if x not in s]
    for deletedParam in diff:
        changesNew = {}
        for change in changes.items():
            changesNew[change[0]] = change[1]
        changesNew['changeType'] = 'Parameter deleted'
        changesNew['oldValue'] = deletedParam
        changeList.append(changesNew)

def reconcileParameterValueAddedOrDeleted(parametersAdded, parametersDeleted):
    if (bool(parametersDeleted) and bool(parametersAdded)):
        getParameterValueAdded(parametersAdded, parametersDeleted)
        getParameterValueDeleted(parametersAdded, parametersDeleted)
    elif not bool(parametersDeleted) and bool(parametersAdded):
        getParameterValueAdded(parametersAdded, parametersDeleted)
    elif not bool(parametersAdded) and bool(parametersDeleted):
        getParameterValueDeleted(parametersAdded, parametersDeleted)

def getEditedParameters():
    global paramValues
    paramEditItems = scenarioItem['items']

    parametersAdded = []
    parametersRemoved = []

    for paramValueEdit in paramEditItems:
        changes["parameter"] = paramValueEdit['label']
        for paramValues in paramValueEdit['items']:
            if paramValues['action'] == 'Parameter value edited':
                getParameterValues()
            elif paramValues['action'] == 'Parameter value deleted':
                parametersRemoved.append(paramValues['rows'])
            elif paramValues['action'] == 'Parameter value added':
                parametersAdded.append(paramValues['rows'])
    reconcileParameterValueAddedOrDeleted(parametersAdded, parametersRemoved)

def getAddedOrDeletedParameters():
    paramItems = scenarioItem['rows']
    for paramItem in paramItems:
        changesNew = {}
        for change in changes.items():
            changesNew[change[0]] = change[1]
        changesNew["parameter"] = paramItem[0]['value']
        if scenarioItem['action'] == 'Parameters added':
            changesNew['changeType'] = 'Parameter added'
        if scenarioItem['action'] == 'Parameters deleted':
            changesNew['changeType'] = 'Parameter deleted'
        changeList.append(changesNew)

def getEditedScenarios():
    global changes, scenarioItem
    if actionItem['action'] == 'Scenarios edited':
        scenarios = actionItem['items']
        for scenario in scenarios:
            changes = {}
            changes["version"] = version
            changes["timestamp"] = timestamp
            changes["userid"] = userid
            changes["scenario"] = scenario['label']
            for scenarioItem in scenario['items']:
                if scenarioItem['action'] == 'Parameters edited':
                    getEditedParameters()
                if scenarioItem['action'] == 'Parameters added' or scenarioItem['action'] == 'Parameters deleted':
                    getAddedOrDeletedParameters()

for action in actions:
    if (action['actionType'] == 'FLOW_UPDATED'):
        link = action['links'][0]
        uri = link['uri']
        type = link['type']

        headersGetAction = {
            'Authorization': 'Bearer ' + access_token,
            'Accept': type
        }
        getActionResponse = getAction(headersGetAction, uri)
        actionData = getActionResponse.json()
        version = actionData['version']
        timestamp = actionData['createdAt']
        userid = actionData['createdBy']
        actionItems = actionData['items']

        for actionItem in actionItems:
            getEditedScenarios()


df = pd.DataFrame(changeList)
if df.empty:
    print("No changes have been made to ScenarioParameters for flow with guid '" + flowGuid + "'")
else:
    sorted_scen_parameter_changes = df.sort_values(by=['version', 'timestamp'], ascending=False)

    with pd.ExcelWriter(output_file) as writer:
        sorted_scen_parameter_changes.to_excel(writer, sheet_name='ScenarioParameterChanges')
