/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solutions.fis.fm;

import com.sas.solutions.fis.fm.auth.WIPServicesClientRegistry;
import com.sas.solutions.keys.SolutionsKey;
import com.sas.solutions.odcs.client.CacheManagerDelegate;
import com.sas.solutions.odcs.client.interfaces.CacheManagerInterfaceRemote;
import com.sas.solutions.odcs.client.interfaces.VCubeFinderInterfaceRemote;
import com.sas.solutions.odcs.client.interfaces.VCubeManagerInterfaceRemote;
import com.sas.solutions.odcs.client.model.Locator;
import com.sas.solutions.odcs.client.model.VCubeDTO;
import com.sas.solutions.odcs.client.model.VCubeID;
import com.sas.solutions.odcs.client.util.ODCSBaseDelegate;
import com.sas.solutions.services.locator.WIPServicesLocator;
import com.sas.svcs.config.client.ApplicationRegistration;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import com.sas.svcs.security.authentication.client.AuthenticationClient;
import com.sas.svcs.security.authentication.client.AuthenticationClientHolder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LoadCache {
    private static final Logger logger = Logger.getLogger(LoadCache.class);
    private static final Locator locator = Locator.CURRENT_TIME_NO_NLS;

    public static void main(String[] args) {
        String user = args[0];
        String pass = args[1];
        String host3 = args[2];
        String port3 = args[3];
        String host4 = args[4];
        String port4 = args[5];
        String url1 = "http://" + host3 + ":" + port3 + "/SASFinancialManagementCore";
        String url2 = "http://" + host4 + ":" + port4 + "/SASODCSReadOnly";
        String vcubes = args[6];
        String str_threads = args[7];
        String flush_cache = args[8];
        String fm_version = args[9];
        String fm_web = "Financial Mgmt WebServices " + fm_version;
        String fm_web_url = "http://" + host3 + ":" + port3 + "SASFinancialManagementCore";
        String odcs_web = "ODCS for Sol WebServices " + fm_version;
        String odcs_web_url = "http://" + host4 + ":" + port4 + "SASODCSReadOnly";
        int threads = Integer.valueOf(str_threads);
        System.setProperty(fm_web, fm_web_url);
        System.setProperty(odcs_web, odcs_web_url);
        System.out.println("Running loading VCubes with " + threads + " threads for VCubes: " + vcubes);
        System.out.println(String.valueOf(fm_web) + " = " + fm_web_url);
        System.out.println(String.valueOf(odcs_web) + " = " + odcs_web_url);
        LoadCache.loadVCubes(user, pass, host3, port3, url1, url2, vcubes, threads, flush_cache);
    }

    public static String getHostInfo() {
        String hostName = null;
        int port = 0;
        try {
            ConfigurationServiceInterface configurationService = WIPServicesLocator.getConfigurationService();
            ApplicationRegistration registration = configurationService.getRegistration(SolutionsKey.ODCS_WEBSERVICES_COMPONENT);
            hostName = registration.getHost();
            port = registration.getPort();
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to get host and port information from configuration service for software component: " + SolutionsKey.ODCS_WEBSERVICES_COMPONENT), (Throwable)ex);
        }
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return String.valueOf(hostName) + ":" + port;
    }

    public static void findVCubes(String user, String password, String host, String port, String url_fm, String url_odcs) {
        VCubeDTO cube;
        logger.info((Object)"Locating VCubes on each server");
        System.setProperty("sas.svcs.registry.host", host);
        System.setProperty("sas.svcs.registry.port", port);
        LoadCache.login(user, password);
        VCubeFinderInterfaceRemote vcubeMgrS3 = (VCubeFinderInterfaceRemote)ODCSBaseDelegate.getBean(null, (String)"odcs.vcubeFinderHttpService", (String)SolutionsKey.FMS_WEBSERVICES_COMPONENT, (String)url_fm);
        VCubeFinderInterfaceRemote vcubeMgrS4 = (VCubeFinderInterfaceRemote)ODCSBaseDelegate.getBean(null, (String)"odcs.vcubeFinderHttpService", (String)SolutionsKey.ODCS_WEBSERVICES_COMPONENT, (String)url_odcs);
        VCubeDTO[] s3cubes = vcubeMgrS3.getVCubes(new Locator());
        VCubeDTO[] s4cubes = vcubeMgrS4.getVCubes(new Locator());
        VCubeDTO[] vCubeDTOArray = s3cubes;
        int n = s3cubes.length;
        int n2 = 0;
        while (n2 < n) {
            cube = vCubeDTOArray[n2];
            logger.info((Object)("FM r/w cube=" + cube.getCode()));
            ++n2;
        }
        vCubeDTOArray = s4cubes;
        n = s4cubes.length;
        n2 = 0;
        while (n2 < n) {
            cube = vCubeDTOArray[n2];
            logger.info((Object)("FM ro cube=" + cube.getCode()));
            ++n2;
        }
        LoadCache.logout();
    }

    /*
     * Unable to fully structure code
     */
    public static void loadVCubes(String user, String password, String host, String port, String url_fm, String url_odcs, String vcubes, int threads, String flush_cache) {
        block21: {
            LoadCache.logger.info((Object)"loadVCubes() start");
            start = System.currentTimeMillis();
            infoLogging = LoadCache.logger.isInfoEnabled();
            System.setProperty("sas.svcs.registry.host", host);
            System.setProperty("sas.svcs.registry.port", port);
            LoadCache.logger.debug((Object)("sas.svcs.registry.host=" + host));
            LoadCache.logger.debug((Object)("sas.svcs.registry.port=" + port));
            LoadCache.logger.debug((Object)("fis.vcubes = " + vcubes));
            LoadCache.login(user, password);
            if (flush_cache.contentEquals("true")) {
                cacheMgrFM = new CacheManagerDelegate();
                cacheMgrODCS = new CacheManagerDelegate();
                readOnlyCacheMgr = null;
                readOnlyCacheMgr = (CacheManagerInterfaceRemote)ODCSBaseDelegate.getBean(readOnlyCacheMgr, (String)"odcs.cacheManagerHttpService", (String)SolutionsKey.ODCS_WEBSERVICES_COMPONENT, null);
                LoadCache.logger.info((Object)"FM flush caches started...");
                readOnlyCacheMgr.clearCaches();
                cacheMgrFM.flushCaches();
                LoadCache.logger.info((Object)"FM flush caches done!");
            }
            vcubeMgr = (VCubeFinderInterfaceRemote)ODCSBaseDelegate.getBean(null, (String)"odcs.vcubeFinderHttpService", (String)SolutionsKey.FMS_WEBSERVICES_COMPONENT, (String)url_fm);
            vcubeMgrS3 = (VCubeManagerInterfaceRemote)ODCSBaseDelegate.getBean(null, (String)"odcs.vcubeManagerHttpService", (String)SolutionsKey.FMS_WEBSERVICES_COMPONENT, (String)url_fm);
            vcubeMgrS4 = (VCubeManagerInterfaceRemote)ODCSBaseDelegate.getBean(null, (String)"odcs.vcubeManagerHttpService", (String)SolutionsKey.ODCS_WEBSERVICES_COMPONENT, (String)url_odcs);
            cores = Runtime.getRuntime().availableProcessors();
            if (cores < threads) {
                LoadCache.logger.warn((Object)"The number of threads exceeds the available resources reported by the system.");
                LoadCache.logger.warn((Object)"NOTE: This will result in slower performance of the loadcache mechanism!");
                LoadCache.logger.warn((Object)("  Threads set:  " + threads));
                LoadCache.logger.warn((Object)("  System cores: " + cores));
            } else {
                LoadCache.logger.info((Object)"Hyperthreading is not advised for performance with SAS and FM.  ");
                LoadCache.logger.info((Object)("  Threads set:  " + threads));
                LoadCache.logger.info((Object)("  System cores: " + cores));
            }
            executor = Executors.newFixedThreadPool(threads);
            results = null;
            tasks = new ArrayList<Callable<VCubeID>>();
            vcubeIds = vcubes.split(",");
            successCount = 0;
            failCount = 0;
            preloadedVCubeIDs = new HashSet<VCubeID>();
            var27_22 = vcubeIds;
            var26_25 = vcubeIds.length;
            var25_29 = 0;
            while (var25_29 < var26_25) {
                block22: {
                    id = var27_22[var25_29];
                    if (id.trim().length() == 0) break block22;
                    try {
                        intId = Integer.parseInt(id.trim());
                        cubeID = new VCubeID(intId);
                        cubeByID = vcubeMgr.findVCube(cubeID);
                        if (cubeByID == null) {
                            LoadCache.logger.warn((Object)("preload failed:  invalid cube id: " + id));
                            ++failCount;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        cubeByCode = vcubeMgr.findVCubeByCode(id, LoadCache.locator);
                        if (cubeByCode != null) ** break block23
                        LoadCache.logger.warn((Object)("preload failed:  invalid cube id: " + id));
                        ++failCount;
                    }
                    break block22;
                    {
                        intId = cubeByCode.getID().intValue();
                    }
                    vcubeID = new VCubeID(intId);
                    preloadedVCubeIDs.add(vcubeID);
                    tasks.add(new PreloadVCube3(vcubeMgrS3, vcubeID));
                    tasks.add(new PreloadVCube4(vcubeMgrS4, vcubeID));
                }
                ++var25_29;
            }
            if (tasks.size() > 0) {
                try {
                    try {
                        results = executor.invokeAll(tasks);
                        if (infoLogging) {
                            for (Future<T> v : results) {
                                if (v.get() != null) {
                                    ++successCount;
                                    continue;
                                }
                                ++failCount;
                            }
                            duration = System.currentTimeMillis() - start;
                            sb = new StringBuilder(256);
                            sb.append("loadVCubes() successfully loaded ");
                            sb.append(successCount);
                            sb.append(" cube(s) across 2 servers");
                            if (failCount > 0) {
                                sb.append(", and failed to load ");
                                sb.append(failCount);
                                sb.append(" other cube(s),");
                            }
                            sb.append(" in ");
                            sb.append(duration);
                            sb.append(" ms");
                            LoadCache.logger.info((Object)sb.toString());
                        }
                    }
                    catch (Exception ex) {
                        LoadCache.logger.error((Object)"preload failed", (Throwable)ex);
                        executor.shutdown();
                        break block21;
                    }
                }
                catch (Throwable var27_23) {
                    executor.shutdown();
                    throw var27_23;
                }
                executor.shutdown();
            }
        }
        s3cubes = vcubeMgr.getVCubes(new Locator());
        cubeCount = 0;
        var29_40 = s3cubes;
        var28_39 = s3cubes.length;
        var27_24 = 0;
        while (var27_24 < var28_39) {
            cube = var29_40[var27_24];
            ++cubeCount;
            ++var27_24;
        }
        if (cubeCount > preloadedVCubeIDs.size()) {
            LoadCache.logger.info((Object)"Additional VCubes available to preload:");
            var29_40 = s3cubes;
            var28_39 = s3cubes.length;
            var27_24 = 0;
            while (var27_24 < var28_39) {
                vcube = var29_40[var27_24];
                vcubeId = vcube.getID();
                LoadCache.logger.debug((Object)("vcubeId=" + vcubeId));
                LoadCache.logger.debug((Object)("preloaded set=" + preloadedVCubeIDs.contains(vcubeId)));
                if (!preloadedVCubeIDs.contains(vcubeId)) {
                    LoadCache.logger.debug((Object)(" Preloaded comparing to valueOf=" + vcubeId));
                    LoadCache.logger.info((Object)("    vcube id: " + vcubeId + ", code: " + vcube.getCode()));
                }
                ++var27_24;
            }
        }
        LoadCache.logout();
    }

    private static boolean isCompatibleVersion(String version, String desired) {
        Pattern p = Pattern.compile("[._\\-]");
        String[] ds = p.split(desired);
        String[] vs = p.split(version);
        int i = 0;
        while (i < ds.length) {
            int d = Integer.parseInt(ds[i]);
            int v = Integer.parseInt(vs[i]);
            if (v < d) {
                return false;
            }
            if (v > d) {
                return true;
            }
            ++i;
        }
        return true;
    }

    public static int getIntegerProperty(String name, int dflt) {
        String s = System.getProperty(name);
        int n = dflt;
        if (s == null) {
            logger.debug((Object)(String.valueOf(name) + "=" + n));
        } else {
            try {
                n = LoadCache.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            logger.info((Object)(String.valueOf(name) + "=" + n));
        }
        return n;
    }

    public static double getDoubleProperty(String name, double dflt) {
        String s = System.getProperty(name);
        double n = dflt;
        if (s != null) {
            try {
                n = Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                logger.info((Object)("Invalid setting for " + name + ". Using default " + n));
            }
        }
        logger.info((Object)(String.valueOf(name) + "=" + n));
        return n;
    }

    public static int parseInt(String s) {
        int n = 0;
        if (s != null) {
            long mult = 1L;
            if (s.endsWith("M") || s.endsWith("m")) {
                mult = 0x100000L;
                s = s.substring(0, s.length() - 1);
            } else if (s.endsWith("K") || s.endsWith("k")) {
                mult = 1024L;
                s = s.substring(0, s.length() - 1);
            }
            n = Integer.parseInt(s);
            n = (int)((long)n * mult);
        }
        return n;
    }

    public static boolean getBooleanProperty(String name, boolean dflt) {
        boolean b = dflt;
        String s = System.getProperty(name);
        if (s == null) {
            logger.debug((Object)(String.valueOf(name) + "=" + b));
        } else {
            if ((s = s.trim()).length() != 0) {
                b = Boolean.valueOf(s);
            }
            logger.info((Object)(String.valueOf(name) + "=" + b));
        }
        return b;
    }

    public static String getStringProperty(String name, String dflt) {
        String s = System.getProperty(name);
        if (s == null) {
            s = dflt;
            logger.debug((Object)(String.valueOf(name) + "=" + s));
        } else {
            logger.info((Object)(String.valueOf(name) + "=" + s));
        }
        return s;
    }

    public static AuthenticationClient login(String user, String password) {
        String logonMgrUrl = WIPServicesClientRegistry.getLogonManagerURL();
        AuthenticationClient authClient = new AuthenticationClient(logonMgrUrl);
        logger.debug((Object)("LOGON: " + user));
        authClient.logon(user, password);
        AuthenticationClientHolder.set((AuthenticationClient)authClient);
        return authClient;
    }

    public static void logout() {
        LoadCache.logout(AuthenticationClientHolder.get());
    }

    public static void logout(AuthenticationClient authClient) {
        if (authClient != null) {
            authClient.logout();
        }
    }

    private static class PreloadVCube3
    implements Callable<VCubeID> {
        private VCubeManagerInterfaceRemote vcubeMgr3 = null;
        private VCubeID vcubeID = null;

        public PreloadVCube3(VCubeManagerInterfaceRemote vcubeMgr3, VCubeID vcubeID) {
            this.vcubeMgr3 = vcubeMgr3;
            this.vcubeID = vcubeID;
        }

        @Override
        public VCubeID call() throws Exception {
            VCubeID retval = this.vcubeID;
            try {
                long startLoad = System.currentTimeMillis();
                this.vcubeMgr3.loadVCube(this.vcubeID);
                long loadCubeTime = System.currentTimeMillis() - startLoad;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("preloaded vcube " + this.vcubeID.getId() + " on FM rw in " + loadCubeTime + " ms"));
                }
            }
            catch (Exception e) {
                logger.error((Object)("preload failed: " + this.vcubeID.getId()), (Throwable)e);
                retval = null;
            }
            return retval;
        }
    }

    private static class PreloadVCube4
    implements Callable<VCubeID> {
        private VCubeManagerInterfaceRemote vcubeMgr4 = null;
        private VCubeID vcubeID = null;

        public PreloadVCube4(VCubeManagerInterfaceRemote vcubeMgr4, VCubeID vcubeID) {
            this.vcubeMgr4 = vcubeMgr4;
            this.vcubeID = vcubeID;
        }

        @Override
        public VCubeID call() throws Exception {
            VCubeID retval = this.vcubeID;
            try {
                long startLoad = System.currentTimeMillis();
                this.vcubeMgr4.loadVCube(this.vcubeID);
                long loadCubeTime = System.currentTimeMillis() - startLoad;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("preloaded vcube " + this.vcubeID.getId() + " on FM ro in " + loadCubeTime + " ms"));
                }
            }
            catch (Exception e) {
                logger.error((Object)("preload failed: " + this.vcubeID.getId()), (Throwable)e);
                retval = null;
            }
            return retval;
        }
    }
}

