#!/bin/ksh
#############################################################################################################################################
echo 'Collecting SAS Artifacts for Web Application Server (JBoss, WebLogic, Tomcat) JDK Performance, Hang or High CPU Issues on AIX Platform' 
#############################################################################################################################################


SCRIPT_SPAN=240          # How long the whole script should take.   Default=240 secs
JAVACORE_INTERVAL=120    # How often javacores should be taken.    Default=120  secs
VMSTAT_INTERVAL=5        # How often vmstat data should be taken. Default=5 secs
TPROF_SPAN=60            # How long tprof should collect data.   Default=60  secs

                                                 


if [ $# -eq 0 ]
then
echo "$0 : Unable to find required PID argument.  Please rerun the script as follows:"
echo "$0 : ./aixperf.sh [PID(s)_of_the_problematic_JVM(s)_separated_by_spaces]"
exit 1
fi

# Create the screen.out and put the current date in it.
echo > screen.out
date >> screen.out

# Starting up
print $(date) "Collecting  AIX JVM Performance  Artifacts  >> aixperf.sh script starting..." | tee -a screen.out


# Display the PIDs which have been input to the script
for i in $*
do
	print $(date) "Collecting  AIX JVM Performance  Artifacts >> PROBLEMATIC_PID is:  $i" | tee -a screen.out
done

# Display the being used in this script
echo $(date) "Collecting  AIX JVM Performance  Artifacts  >> SCRIPT_SPAN = $SCRIPT_SPAN" | tee -a screen.out
echo $(date) "Collecting  AIX JVM Performance  Artifacts  >> JAVACORE_INTERVAL = $JAVACORE_INTERVAL" | tee -a screen.out
echo $(date) "Collecting  AIX JVM Performance  Artifacts  >> VMSTAT_INTERVAL = $VMSTAT_INTERVAL" | tee -a screen.out
echo $(date) "Collecting  AIX JVM Performance  Artifacts  >> TPROF_SPAN = $TPROF_SPAN" | tee -a screen.out

# Collect the user currently executing the script
echo $(date) "Collecting  AIX JVM Performance  Artifacts >> Collecting user authority data..." | tee -a screen.out
date > whoami.out
whoami >> whoami.out 2>&1
echo $(date) "Collecting  AIX JVM Performance  Artifacts>> Collection of user authority data complete." | tee -a screen.out
 
# Create some of the output files with a blank line at top
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Creating output files..." | tee -a screen.out
echo > netstat.out
echo > vmstat.out
echo > ps.out
echo > tprof.out
print $(date) "Collecting  AIX JVM Performance  Artifacts >>      Output files created:" | tee -a screen.out
print $(date) "Collecting  AIX JVM Performance  Artifacts >>      netstat.out" | tee -a screen.out
print $(date) "Collecting  AIX JVM Performance  Artifacts >>      vmstat.out" | tee -a screen.out
print $(date) "Collecting  AIX JVM Performance  Artifacts >>      ps.out" | tee -a screen.out
print $(date) "Collecting  AIX JVM Performance  Artifacts >>      tprof.out" | tee -a screen.out 


# Collect the first netstat: date at the top, data, and then a blank line
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Collecting the first netstat snapshot..." | tee -a screen.out
date >> netstat.out
netstat -an >> netstat.out 2>&1
echo >> netstat.out
print $(date) "Collecting  AIX JVM Performance  Artifacts>> First netstat snapshot complete." | tee -a screen.out

# Collect the first ps: date at the top, data, and then a blank line
print $(date) "Collecting  AIX JVM Performance  Artifacts >> Collecting the first ps snapshot..." | tee -a screen.out
date >> ps.out
ps avwwwg >> ps.out 2>&1
echo >> ps.out
print $(date) "Collecting  AIX JVM Performance  Artifacts >> First ps snapshot complete." | tee -a screen.out


# Start the colletion of vmstat data.

print $(date) "Collecting  AIX JVM Performance  Artifacts>> Starting collection of vmstat data..." | tee -a screen.out
date >> vmstat.out
vmstat $VMSTAT_INTERVAL `expr $SCRIPT_SPAN / $VMSTAT_INTERVAL + 1` >> vmstat.out 2>&1 &
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Collection of vmstat data started." | tee -a screen.out

# Start the collection of tprof data.

print $(date) "Collecting  AIX JVM Performance  Artifacts>> Starting collection of tprof data..." | tee -a screen.out
date >> tprof.out

if  /usr/sbin/smtctl >/dev/null 2>&1; then
        KERTYPE=`getconf KERNEL_BITMODE`
        if [ "$KERTYPE" = 32 ]; then
                print $(date) "Collecting  AIX JVM Performance  Artifacts>> TPROF_ARGS set to -skex; SMT capable but 32 bit environment." | tee -a screen.out
				TPROF_ARGS="-skex"
        else
                print $(date) "Collecting  AIX JVM Performance  Artifacts>> TPROF_ARGS set to -Rskex; SMT capable and NOT a 32 bit environment." | tee -a screen.out
				TPROF_ARGS="-Rskex"
        fi
else
        print $(date) "Collecting  AIX JVM Performance  Artifacts>> TPROF_ARGS set to -skex; Not SMT capable." | tee -a screen.out
		TPROF_ARGS="-skex"
fi
LDR_CNTRL=MAXDATA=0x80000000 tprof $TPROF_ARGS sleep $TPROF_SPAN >> tprof.out 2>&1 &
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Collection of tprof data started." | tee -a screen.out


# Start collection of javacores.

n=1
m=`expr $SCRIPT_SPAN / $JAVACORE_INTERVAL`
while [ $n -le $m ]
do
	print $(date) "Collecting  AIX JVM Performance  Artifacts>> Collecting javacores..." | tee -a screen.out
	for i in $*
	do
		kill -3 $i >> screen.out 2>&1
		print $(date) "Collecting  AIX JVM Performance  Artifacts>> Collected a javacore for PID $i." | tee -a screen.out

	done
	print $(date) "Collecting  AIX JVM Performance  Artifacts>> Continuing to collect data for $JAVACORE_INTERVAL seconds..." | tee -a screen.out
	sleep $JAVACORE_INTERVAL
	n=`expr $n + 1`
done

# Collect the final javacore(s).
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Collecting final javacore..." | tee -a screen.out
for i in $*
do
	kill -3 $i >> screen.out 2>&1
	print $(date) "Collecting  AIX JVM Performance  Artifacts>> Collected the final javacore for PID $i." | tee -a screen.out
done


# Collect the final ps
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Collecting the final ps snapshot..." | tee -a screen.out
date >> ps.out
ps avwwwg >> ps.out 2>&1
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Final ps snapshot complete." | tee -a screen.out

# Collect a final netstat
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Collecting the final netstat snapshot..." | tee -a screen.out
date >> netstat.out
netstat -an >> netstat.out 2>&1
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Final netstat snapshot complete." | tee -a screen.out
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Collecting other data.  This may take a few moments..." | tee -a screen.out

/usr/sbin/emgr -lv3 > emgr-lv3.out 2>&1
oslevel -s > oslevel-s.out 2>&1
lslpp -la > lslpp-la.out 2>&1
instfix -i > instfix-i.out 2>&1
prtconf > prtconf.out 2>&1
lparstat -i > lparstat-i.out 2>&1
lsattr -El sys0 > lsattr.out 2>&1
df > df.out 2>&1

print $(date) "Collecting  AIX JVM Performance  Artifacts>> Collected other data." | tee -a screen.out


# Brief pause to make sure all data is collected.
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Preparing for packaging and cleanup..." | tee -a screen.out
sleep 5

# Build a string to contain all the file names
FILES_STRING="netstat.out vmstat.out ps.out sleep.prof screen.out tprof.out emgr-lv3.out oslevel-s.out lslpp-la.out instfix-i.out prtconf.out lparstat-i.out lsattr.out whoami.out df.out"

# Tar/GZip the output files together
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Compress output files into aixperf_RESULTS.tar.gz"
tar -cvf aixperf_RESULTS.tar $FILES_STRING
gzip aixperf_RESULTS.tar

# Clean up the output files now that they have been tar/gz'd.
print $(date) "Collecting  AIX JVM Performance  Artifacts>> Remove the temporary output files as they have now been added to the aixperf_RESULTS.tar.gz file."
rm $FILES_STRING

