/*+----------------------------------------------------------------+
  | Copyright (c) 2003 by SAS Institute Inc., Cary, NC, USA. All Rights Reserved.
  | Name:     etlfcto.sas
  | Support:  itaens
  | Product:  SES
  | Language: SAS
  | Usage:
  |
  !
  | Purpose:  Allow to load base facts into SFM from ETL studio
  | History:  Date      Action
  |           08aug2004 initial coding
  |           28Mar2007 added source to macro (Base/BaseForm)
  | Future:
  | Note:  use proc pwencode to generate an encrypted password.  Example:
  |            proc PWENCODE in="my password";run;
  |        generates the following output:  {sas001}bXkgcGFzc3dvcmQ=
  |
  +----------------------------------------------------------------+*/
%macro etlfcto(cycle, period, analysis, org, source, usr, pwd, environment);
data _null_;
    dcl javaobj j("com/sas/solutions/finance/api/BaseFactLoad");
    j.ExceptionDescribe(1);
    length src $1;
    length cycle period analysis org $ 100;
    length source $ 32;
    length msg $ 512 ;
    length url $ 1000;
    length count $ 7;
    length usr pwd environment $128;
    cycle=symget("cycle");
    period=symget("period");
    analysis=symget("analysis");
    source=symget("source");
    org=symget("org");
    put cycle= period= analysis= org=;
    usr=symget("usr");
    pwd=symget("pwd");
    environment=symget("environment");
    j.callStringMethod("loadBaseFactsByOrg", strip(cycle), strip(period), strip(analysis),
                        strip(source), strip(org), strip(usr), strip(pwd), strip(environment), src);

    j.callStringMethod("getMessage", msg);
    put msg ;

    /*  Status handling  */
    if strip(src) = "0" then do;
       * load successful ;
       j.callStringMethod("getTransactionsCount", count);
       put 'Note: successfully import ' count ' facts.';
    end;
    else if strip(src) = "3" then do;
    end;
    else do;
       j.callStringMethod("getReportURL", url);
       if url ne '' then do ;
         put 'Note: for further information please see report at URL:' url;
       end ;
       j.delete();
       abort ;
    end;
    j.delete();

run;
%mend;
