/* Example script to run the 913 omabakup backup macro with support for
 * dynamic XML encoding.  20Feb2009
 */

/* NOTES: 
 * This procedure creates a fileref to the location where you have stored the 
 * omabakup913Encoding.sas macro.  By reading the file in as encoding utf8, 
 * the filename statement will cause SAS to execute using the current session
 * encoding. Submit this .sas file in the SAS program editor, or run it from
 * a command line. This sequence should work fine on all hosts in all
 * encodings.
 *
 * The omabakup913Encoding.sas file must be an ascii file.  For z/OS, 
 * this file must be ftp'd to the HFS filesystem in binary. Also for z/OS,
 * the file omabakup913EncodingScript.sas must be ftp'd to the HFS 
 * filesystem in ascii.
 * 
 * This script uses generic pathnames that are appropriate for Unix systems and z/OS. 
 * You must update these pathnames appropriately for your operating 
 * environment.  
 */

/* Create a fileref that will read the macro file into the sas session as utf8.
 * Execute the macro using the current sas session encoding. 
 */
filename omabakup '/Path-to-the-macro-file/omabakup913Encoding.sas' encoding="utf8";
%include omabakup;

/* Set the applicable values in the server connection statement. */ 
options nomprint nomlogic nosymbolgen;
options metaserver='HostName'
metaport=8561   
metaprotocol='bridge'
metauser='Userid'
metapass='XXXXX'     /* use proc pwencode to encrypt this password */
metarepository='Foundation'
;

/* Execute the macro in the current session encoding. */
%omabakup(
DestinationPath='/SAS-configuration-directory/Lev1/SASMain/SASBackup',
ServerStartPath='/SAS-configuration-directory/Lev1/SASMain',
RposmgrPath='MetadataServer/rposmgr')

