VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "msflxgrd.ocx"
Begin VB.Form Main 
   Caption         =   "ADO IOM Sample"
   ClientHeight    =   5010
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   7665
   LinkTopic       =   "Form1"
   ScaleHeight     =   5010
   ScaleWidth      =   7665
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtEdit 
      Appearance      =   0  'Flat
      Height          =   285
      Left            =   480
      TabIndex        =   1
      Top             =   2880
      Visible         =   0   'False
      Width           =   1215
   End
   Begin MSFlexGridLib.MSFlexGrid grdData 
      Height          =   2415
      Left            =   360
      TabIndex        =   0
      Top             =   360
      Width           =   3855
      _ExtentX        =   6800
      _ExtentY        =   4260
      _Version        =   393216
      ScrollTrack     =   -1  'True
      AllowUserResizing=   1
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuReload 
         Caption         =   "&Reload"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
End
Attribute VB_Name = "Main"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This sample demonstrates how to
' - create a SAS workspace that runs on the a local machine
' - use the SAS language to work with data on a SAS IOM server
' - use ADO to access a SAS data set through the SAS IOM Data Provider
' - use the MSFlexGrid control.

' Note that you can update the data in the MSFlexGrid.

' To run this sample, your machine must contain the following software:
' - Microsoft ActiveX Data Objects 2.7 Library
' - Microsoft Visual Basic 6.0, including the Microsoft Flex Grid control
' - the SAS System, Release 8.2.

' To run this sample, you must reference the following type libraries:
' Microsoft ActiveX Data Objects 2.7 Library
' SAS: Integrated Object Model (IOM) 1.0 Type Library
' SASWorkspaceManager 1.0 Type Library.
Option Explicit

Private obSAS As SAS.Workspace
Private obWM As New SASWorkspaceManager.WorkspaceManager

Private obConnection As New ADODB.Connection
Private obRecordset As New ADODB.Recordset
Private bookmarks As Variant
Private editRow As Long
Private editCol As Long
Private defaultHeight As Long
Private maxRows As Long
Private bClosing As Boolean

Private Sub Form_Load()
    ' Setup default values.
    defaultHeight = grdData.RowHeight(1)
    maxRows = 10001
    bClosing = False

    ' Show the grid from the begining.
    Me.Show
    DoEvents
    
    ' Create a local SAS workspace.
    Dim xmlinfo As String
    Set obSAS = obWM.Workspaces.CreateWorkspaceByServer("", VisibilityProcess, Nothing, "", "", xmlinfo)
    obSAS.LanguageService.Submit "data a; do customer=1 to 100; quantity=customer*customer; pizza='Pepperoni'; output;end;run;"
    
    ' Open a connection to the workspace.
    obConnection.Open "Provider=sas.IOMProvider.1; SAS Workspace ID=" & obSAS.UniqueIdentifier
    
    ' Associate the Recordset object with the SAS data set.
    obRecordset.ActiveConnection = obConnection
    obRecordset.CacheSize = 55
    obRecordset.Properties("SAS Page Size") = 55
    obRecordset.Properties("Maximum Open Rows") = 110
    obRecordset.Open "work.a", , adOpenDynamic, adLockPessimistic, ADODB.adCmdTableDirect
    
    ' Modify the value of the pizza field in the first record.
    obRecordset!pizza = "mushroom"
    
    ' Move to the next record in the recordset.
    obRecordset.MoveNext
    
    ' Modify the value of pizza field in the second record.
    obRecordset!pizza = "cheese"

    ' Assign the correct number of columns to the grid.
    grdData.Cols = obRecordset.Fields.Count + 1
    
    ' Assign column names to the grid headers.
    Dim i As Long
    grdData.Row = 0
    For i = 0 To grdData.Cols - 2
        grdData.Col = i + 1
        grdData.Text = obRecordset.Fields(i).Name
    Next
    
    ' Load the data into the recordset.
    LoadRecordset
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    bClosing = True
End Sub

Private Sub Form_Unload(Cancel As Integer)
    ' Close the ADO objects if they are open.
    If obRecordset.State = adStateOpen Then obRecordset.Close
        Set obRecordset = Nothing
    If obConnection.State = adStateOpen Then obConnection.Close
        Set obConnection = Nothing
    
    ' Close the SAS Workspace object.
    If Not (obSAS Is Nothing) Then
        ' Because we specify "VisibilityProcess" on the CreateWorkspaceByServer
        ' call, we need to tell the WorkspaceManager that we're done with this
        ' workspace.  If we had used a value of "VisibilityNone", then we
        ' wouldn't need to remove this workspace.
        ' But, when using ADO, we must specify "VisibilityProcess" so that the
        ' SAS IOM Data Provider can reference the workspace's UniqueIdentifier
        ' to get the workspace from the WorkspaceManager.
        obWM.Workspaces.RemoveWorkspaceByUUID obSAS.UniqueIdentifier
        obSAS.Close
    End If
End Sub

Private Sub Form_Resize()
    ' End the current editing session if there is one.
    EndEdit
    
    ' Size the grid to be as large as the form.
    grdData.Left = Main.ScaleLeft
    grdData.Top = Main.ScaleTop
    grdData.Height = Main.ScaleHeight
    grdData.Width = Main.ScaleWidth
End Sub

Private Sub LoadRecordset()
    Dim i As Long
    Dim j As Long
    
    Me.MousePointer = vbHourglass
    ' Start with i = 1 because row 0 of the
    ' grid is used for the column names.
    i = 1
    
    ' Move to the beginning of the Recordset.
    obRecordset.MoveFirst
    
    ' Clear out the bookmarks array.
    bookmarks = Array()
    
    ' Read each row.
    While Not obRecordset.EOF And Not obRecordset.BOF
        If i >= maxRows Then
            MsgBox "This dataset is too large for a grid display efficiently.  Only the first " & (grdData.Rows - 1) & " rows will be shown.", vbOKOnly, "IOM Grid Sample"
            GoTo the_end
        End If
        
        ' Breath every 500 rows and if
        ' the window is closed then exit.
        If (i Mod 500) = 0 Then
            DoEvents
            If bClosing Then Exit Sub
        End If
        
        ' Add a new row to the grid if necessary.
        If i >= grdData.Rows Then grdData.Rows = grdData.Rows + 1
        
        ' Add a new element to the bookmarks array if necessary.
        If (i - 1) > UBound(bookmarks) Then ReDim Preserve bookmarks(i - 1)
        
        ' Position the grid on the cell to be updated.
        grdData.Row = i
        grdData.Col = 0
        
        ' Record the observation number and bookmark for this row.
        grdData.Text = i
        bookmarks(i - 1) = CVar(obRecordset.Bookmark)
        
        ' Fill each column on this row and reset the color.
        For j = 0 To obRecordset.Fields.Count - 1
            grdData.Col = j + 1
            grdData.Text = IIf(IsNull(obRecordset.Fields(j).Value), ".", obRecordset.Fields(j).Value)
            grdData.CellForeColor = RGB(0, 0, 0)
            grdData.CellBackColor = RGB(255, 255, 255)
        Next
        
        ' Move to the next row.
        obRecordset.MoveNext
        i = i + 1
    Wend
the_end:
    Me.MousePointer = vbDefault
    ' Position on the first cell.
    grdData.Row = 1
    grdData.Col = 1
End Sub

Private Sub SaveCurrentCell()
    Dim j As Long
    Dim Row As Long
    Dim Col As Long
    On Error GoTo trap
    ' Point the Recordset to the desired row.
    Row = grdData.Row
    Col = grdData.Col
    obRecordset.Bookmark = bookmarks(Row - 1)
    
    ' Check to make sure the value actually changed.
    If (IsNull(obRecordset.Fields(Col - 1).Value) And grdData.Text <> ".") Or (obRecordset.Fields(Col - 1).Value <> grdData.Text) Then
        ' If this column is a double then check to see if the
        ' user wants to set this to missing (".").  Otherwise
        ' set the string value.
        If obRecordset.Fields(Col - 1).Type = adDouble Then
            If grdData.Text = "." Then
                obRecordset.Fields(Col - 1).Value = Null
            Else
                obRecordset.Fields(Col - 1).Value = CDbl(grdData.Text)
            End If
        Else
            obRecordset.Fields(Col - 1).Value = CStr(grdData.Text)
        End If
        obRecordset.Update
        ' Read the data from the recordset so that any
        ' truncation is displayed to the user.
        If IsNull(obRecordset.Fields(Col - 1).Value) Then
            grdData.Text = "."
        Else
            grdData.Text = obRecordset.Fields(Col - 1).Value
        End If
            
        ' Reset the color to indicate success.
        grdData.CellForeColor = RGB(0, 0, 0)
        grdData.CellBackColor = RGB(255, 255, 255)
    End If
    Exit Sub
trap:
    ' Highlight this cell because there was an error.
    grdData.CellForeColor = RGB(255, 0, 0)
    grdData.CellBackColor = RGB(255, 255, 0)
End Sub

Private Sub BeginEdit()
    ' Finish any current editing session.
    EndEdit
    
    ' Store the cell to be edited.
    editRow = grdData.Row
    editCol = grdData.Col

    ' Put the current value of the cell into the edit text box.
    txtEdit.Text = grdData.Text
    
    ' Move the edit text box over the cell to be edited.
    txtEdit.Left = grdData.CellLeft
    txtEdit.Top = grdData.CellTop
    txtEdit.Width = grdData.CellWidth
    ' Can't set the height of the edit box to match the row so
    ' set the height of the row to match the edit box.
    grdData.RowHeight(editRow) = txtEdit.Height
    
    ' Set the edit text box to be visible and highlight
    ' select the contents for easy replacing.
    txtEdit.Visible = True
    txtEdit.SelStart = 0
    txtEdit.SelLength = Len(txtEdit.Text)
    
    ' Give the edit box focus.
    txtEdit.SetFocus
End Sub

Private Sub EndEdit()
    Dim tmpRow As Long
    Dim tmpCol As Long
    If Not txtEdit.Visible Then
        Exit Sub
    End If
    
    ' Store the current cell.
    tmpRow = grdData.Row
    tmpCol = grdData.Col
    
    ' Point the grid at the cell being edited.
    grdData.Row = editRow
    grdData.Col = editCol
    
    ' Restore the hight of the row to the default.
    grdData.RowHeight(editRow) = defaultHeight
    
    ' Hide the edit box.
    txtEdit.Visible = False
    
    ' If the text in the edit text box has been changed
    ' then save that change to the grid and Recordset.
    If grdData.Text <> txtEdit.Text Then
        Debug.Print "Updating cell (" & grdData.Row & ", " & grdData.Col & ") from '" & grdData.Text & "' to '" & txtEdit.Text & "'"
        grdData.Text = txtEdit.Text
        SaveCurrentCell
    End If
    
    ' Restore the original cell.
    grdData.Row = tmpRow
    grdData.Col = tmpCol
    grdData.Visible = True
End Sub

Private Sub grdData_KeyPress(KeyAscii As Integer)
    ' If a key is pressed on the grid then assume that
    ' is the beginning of an edit of the current cell.
    BeginEdit
    ' If it wasn't the return key then put the character
    ' in the edit text box.
    If KeyAscii <> vbKeyReturn Then
        txtEdit.Text = Chr(KeyAscii)
        txtEdit.SelStart = Len(txtEdit.Text)
    End If
End Sub

Private Sub grdData_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
    Debug.Print "Click cell: (" & grdData.Row & ", " & grdData.Col & ")"
    If Button = vbLeftButton Then ' this was a left click.
        If grdData.Row = grdData.RowSel And grdData.Col = grdData.ColSel Then
            ' If only one cell was selected then start a new editing session.
            BeginEdit
        Else
            ' If more than one cell was selected then end the current editing
            ' session but do not start a new one.  The current selection must
            ' be saved and restored.
            Dim tmpRowSel As Long
            Dim tmpColSel As Long
            tmpRowSel = grdData.RowSel
            tmpColSel = grdData.ColSel
            EndEdit
            grdData.RowSel = tmpRowSel
            grdData.ColSel = tmpColSel
        End If
    End If
End Sub

Private Sub grdData_Scroll()
    ' If the user is scrolling the grid then assume
    ' they have finished any editing session they may have.
    EndEdit
End Sub

Private Sub txtEdit_KeyPress(KeyAscii As Integer)
    ' When the edit text box has the focus, escape will cancel
    ' the edit and return will commit the edit.
    If KeyAscii = vbKeyEscape Then
        txtEdit.Text = grdData.TextMatrix(editRow, editCol)
        EndEdit
    ElseIf KeyAscii = vbKeyReturn Then
        EndEdit
    End If
End Sub

Private Sub mnuReload_Click()
    If obConnection.State <> adStateOpen Then
        MsgBox "ERROR: Connection is not open", vbOKOnly, "IOM Grid Sample"
        Exit Sub
    End If
    LoadRecordset
End Sub

Private Sub mnuExit_Click()
    Me.Hide
    Unload Me
End Sub

