﻿using System;
using System.Text;
using SAS.Shared.AddIns;
using SAS.Tasks.Toolkit;

namespace $safeprojectname$
{
    // unique identifier for this task
    [ClassId("$guid1$")]
    // location of the task icon to show in the menu and process flow
    [IconLocation("$safeprojectname$.task.ico")]
    // does this task require input data? 
    // InputResourceType.Data for data set, or 
    // InputResourceType.None for none required
    [InputRequired(InputResourceType.None)]
    public class $safeprojectname$Task : SAS.Tasks.Toolkit.SasTask
    {
        #region private members
        
        private $safeprojectname$TaskSettings settings;

        #endregion

        #region Initialization
        public $safeprojectname$Task()
        {
            InitializeComponent();
        }

        private void InitializeComponent()
        {
            // 
            // $safeprojectname$
            // 
            this.TaskCategory = "SAS Custom Task";
            this.TaskDescription = "Change this description for $safeprojectname$Task";
            this.TaskName = "$safeprojectname$Task";

        }
        #endregion

        #region overrides
        public override bool Initialize()
        {
            settings = new $safeprojectname$TaskSettings();
            return true;
        }

        public override string GetXmlState()
        {
            return settings.ToXml();
        }

        public override void RestoreStateFromXml(string xmlState)
        {
            settings = new $safeprojectname$TaskSettings();
            settings.FromXml(xmlState);
        }

        /// <summary>
        /// Show the task user interface
        /// </summary>
        /// <param name="Owner"></param>
        /// <returns>whether to cancel the task, or run now</returns>
        public override ShowResult Show(System.Windows.Forms.IWin32Window Owner)
        {
            $safeprojectname$TaskForm dlg = new $safeprojectname$TaskForm(this.Consumer);
            dlg.Settings = settings;
            if (System.Windows.Forms.DialogResult.OK == dlg.ShowDialog(Owner))
            {
                // gather settings values from the dialog
                settings = dlg.Settings;
                return ShowResult.RunNow;
            }
            else
                return ShowResult.Canceled;
        }

        /// <summary>
        /// Get the SAS program that this task should generate
        /// based on the options specified.
        /// </summary>
        /// <returns>a valid SAS program to run</returns>
        public override string GetSasCode()
        {
            return settings.GetSasProgram();
        }
        #endregion

    }
}
