﻿using System;
using System.Text;
using System.Xml;

namespace $safeprojectname$
{
    /// <summary>
    /// Use this class to keep track of the 
    /// options that are set within your task.
    /// You must save and restore these settings when the user
    /// interacts with your task user interface,
    /// and when the task runs within the process flow.
    /// </summary>
    public class $safeprojectname$TaskSettings
    {
        public $safeprojectname$TaskSettings()
        {
            SasOption = "YEARCUTOFF";
        }

        #region Properties, or task settings

        public string SasOption { get; set; }

        #endregion

        #region Code to save/restore task settings
        public string ToXml()
        {
            XmlDocument doc = new XmlDocument();
            XmlElement el = doc.CreateElement("$safeprojectname$Task");
            el.SetAttribute("SasOption", SasOption);
            doc.AppendChild(el);
            return doc.OuterXml;
        }

        public void FromXml(string xml)
        {
            XmlDocument doc = new XmlDocument();
            try
            {
                doc.LoadXml(xml);
                XmlElement el = doc["$safeprojectname$Task"];
                SasOption = el.GetAttribute("SasOption");
            }
            catch (XmlException)
            {
                // couldn't read the XML content
            }
        }
        #endregion

        #region Routine to build a SAS program
        public string GetSasProgram()
        {
            return string.Format("proc options option={0}; run;", SasOption);
        }
        #endregion
    }
}
