﻿using System;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using SAS.Shared.AddIns;
using SAS.Tasks.Toolkit.Controls;

namespace $safeprojectname$
{
    /// <summary>
    /// This windows form inherits from the TaskForm class, which
    /// includes a bit of special handling for SAS Enterprise Guide.
    /// </summary>
    public partial class $safeprojectname$TaskForm : SAS.Tasks.Toolkit.Controls.TaskForm
    {
        public $safeprojectname$TaskSettings Settings { get; set; }

        public $safeprojectname$TaskForm(SAS.Shared.AddIns.ISASTaskConsumer3 consumer)
        {
            InitializeComponent();

            // provide a handle to the SAS Enterprise Guide application
            this.Consumer = consumer;
        }

        // initialize the form with the values from the settings
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            txtOption.Text = Settings.SasOption;
        }

        // save any values from the dialog into the settings class
        protected override void OnClosing(CancelEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                Settings.SasOption = txtOption.Text;
            }

            base.OnClosing(e);
        }

    }
}
