﻿Imports SAS.Shared.AddIns
Imports SAS.Tasks.Toolkit
Imports System.Windows.Forms
Imports System.IO
Imports System.Xml.Serialization

<ClassId("$guid1$")> _
<IconLocation("$safeprojectname$.task.ico")> _
<InputRequired(InputResourceType.Data)> _
Public Class $safeprojectname$ : Inherits SAS.Tasks.Toolkit.SasTask

#Region "Initialization"

    Sub New()
        InitializeComponent()
    End Sub

    Sub InitializeComponent()
        '
        'VBTask
        '
        Me.ProductsRequired = "BASE"
        Me.TaskCategory = "SAS Custom Task"
        Me.TaskDescription = "Change this description for your task."
        Me.TaskName = "$safeprojectname$"

    End Sub

#End Region

#Region "Internal fields"
    Private _settings As New $safeprojectname$Settings
#End Region

#Region "Overrides"

    ' This function is called when it's time to show the task window
    Public Overrides Function Show(ByVal Owner As IWin32Window) As SAS.Shared.AddIns.ShowResult
        Dim form As New $safeprojectname$Form
        form.Consumer = Consumer
        If (DialogResult.OK = form.ShowDialog(Owner)) Then
            Return ShowResult.RunNow
        End If
        Return ShowResult.Canceled
    End Function

    ' This function is called when it's time to generate a SAS program
    ' from the task settings so far.
    Public Overrides Function GetSasCode() As String
        ' generate the SAS program and return as a String
        Return "proc options; run;"
    End Function

#Region "Serialization - saving/restored task state"
    Public Overrides Function GetXmlState() As String
        Using sw As New StringWriter()
            Dim s As New XmlSerializer(GetType($safeprojectname$Settings))
            s.Serialize(sw, _settings)
            Return sw.ToString()
        End Using
    End Function

    Public Overrides Sub RestoreStateFromXml(ByVal xmlState As String)
        Using sr As New StreamReader(xmlState)
            Dim s As New XmlSerializer(GetType($safeprojectname$Settings))
            _settings = CType(s.Deserialize(sr), $safeprojectname$Settings)
        End Using
    End Sub
#End Region

#End Region

End Class
